<?php include_once('layout/header.php'); ?>

<?php
$vacancy_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($vacancy_id === 0) {
    header('Location: vacancies.php');
    exit;
}

// Fetch vacancy details using DB class
$vacancy = $con->getRows('vacancies a, job_categories b', array(
    'where' => array('vacancy_id' => $vacancy_id, 'status' => 1, 'a.job_category = b.category_id'),
    'return_type' => 'single'
));

if (!$vacancy) {
    header('Location: vacancies.php');
    exit;
}

$datePosted = $vacancy['date_posted'] ? new DateTime($vacancy['date_posted']) : new DateTime();
$closingDate = new DateTime($vacancy['closing_date']);
$today = new DateTime();
$isClosed = $closingDate < $today;
$daysUntilClosing = $today->diff($closingDate)->days;

// Get related vacancies (same category, excluding current)
$relatedVacancies = $con->getRows('vacancies', array(
    'where' => 'status = 1 AND job_category = ' . $vacancy['job_category'] . ' AND vacancy_id != ' . $vacancy_id,
    'order_by' => 'date_posted DESC',
    'limit' => 3
));

// Get all vacancies for sidebar (recent)
$recentVacancies = $con->getRows('vacancies', array(
    'where' => 'status = 1 AND vacancy_id != ' . $vacancy_id,
    'order_by' => 'date_posted DESC',
    'limit' => 5
));
?>

    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">Job Details</h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="vacancies.php">vacancies</a></li>
                  <li class="breadcrumb-item active"><?php echo htmlspecialchars($vacancy['job_title']); ?></li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->

    <!-- Start Single Vacancy Section -->
    <section class="single-post mega-section">
      <div class="container">
        <div class="row">
          <div class="col-12 col-lg-8">
            <!-- Vacancy Header -->
            <article class="post-article">
              <div class="post-header" style="margin-bottom: 30px; padding-bottom: 25px; border-bottom: 2px solid #f0f0f0;">
                <div style="display: flex; gap: 15px; align-items: flex-start; margin-bottom: 20px;">
                  <div style="background: linear-gradient(135deg, #007b40 0%, #005a2f 100%); color: white; padding: 20px; border-radius: 8px; flex-shrink: 0;">
                    <i class="fas fa-briefcase" style="font-size: 28px;"></i>
                  </div>
                  <div style="flex: 1;">
                    <h1 class="post-title" style="color: #007b40; margin: 0 0 10px 0; font-size: 2.2rem; line-height: 1.3;">
                      <?php echo htmlspecialchars($vacancy['job_title']); ?>
                    </h1>
                    <p style="margin: 0; color: #999; font-size: 14px;">
                      <?php echo htmlspecialchars($vacancy['category']); ?> • Posted <?php echo $con->formatDate($vacancy['date_posted']); ?>
                    </p>
                  </div>
                </div>
              </div>


              <!-- Job Description -->
              <div class="post-content" style="line-height: 1.9; color: #444; font-size: 1rem; margin-bottom: 40px;">
                <h3 style="color: #007b40; margin: 0 0 20px 0; font-size: 1.6rem; font-weight: 700;">Job Description</h3>
                <?php echo $vacancy['job_description']; ?>
              </div>

              <!-- Application Section -->
              <div class="post-footer" style="background: linear-gradient(135deg, #f0f7f4 0%, #ffffff 100%); padding: 30px; border-radius: 8px; border-left: 4px solid #007b40; box-shadow: 0 2px 8px rgba(0, 123, 64, 0.08);">
                <?php if ($isClosed): ?>
                  <div style="text-align: center; padding: 20px;">
                    <i class="fas fa-calendar-times" style="font-size: 36px; color: #dc3545; margin-bottom: 15px; display: block;"></i>
                    <h5 style="margin: 0 0 10px 0; color: #dc3545; font-size: 1.3rem;">Application Period Closed</h5>
                    <p style="margin: 0; color: #666; font-size: 14px;">
                      This position is no longer accepting applications. The closing date was <strong><?php echo $closingDate->format('d F, Y'); ?></strong>. Please check our <a href="vacancies.php" style="color: #007b40; text-decoration: none; font-weight: 600;">vacancies page</a> for other open positions.
                    </p>
                  </div>
                <?php else: ?>
                  <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 20px;">
                    <div style="flex: 1; min-width: 250px;">
                      <h5 style="margin: 0 0 10px 0; color: #007b40; font-size: 1.1rem; font-weight: 600;">Ready to Apply?</h5>
                      <p style="margin: 0; color: #666; font-size: 14px; line-height: 1.6;">
                        Please review all job requirements carefully before submitting your application. Make sure to submit before the closing date: <strong><?php echo $closingDate->format('d F, Y'); ?></strong>
                      </p>
                    </div>
                    <a href="vacancies.php" class="btn" style="background-color: #007b40; color: white; border: none; padding: 12px 28px; border-radius: 4px; text-decoration: none; font-weight: 600; display: inline-flex; align-items: center; gap: 8px; white-space: nowrap; transition: all 0.3s ease;"
                       onmouseover="this.style.backgroundColor='#005a2f';"
                       onmouseout="this.style.backgroundColor='#007b40';">
                      <i class="fas fa-arrow-left"></i> Back to Vacancies
                    </a>
                  </div>
                <?php endif; ?>
              </div>
            </article>
          </div>

          <!-- Sidebar -->
          <div class="col-12 col-lg-4">
            <div class="blog-sidebar">
              <!-- Application Status Card -->
              <div class="sidebar-box" style="background: linear-gradient(135deg, #007b40 0%, #005a2f 100%); color: white; padding: 30px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0, 123, 64, 0.2); margin-bottom: 25px;">
                <div style="text-align: center; margin-bottom: 20px;">
                  <?php if ($isClosed): ?>
                    <i class="fas fa-lock" style="font-size: 48px; opacity: 0.8; display: block; margin-bottom: 15px;"></i>
                    <h4 style="margin: 0; font-size: 1.8rem; font-weight: 700;">Position Closed</h4>
                    <p style="margin: 5px 0 0 0; opacity: 0.9;">This position is no longer accepting applications</p>
                  <?php else: ?>
                    <i class="fas fa-check-circle" style="font-size: 48px; display: block; margin-bottom: 15px;"></i>
                    <h4 style="margin: 0; font-size: 1.8rem; font-weight: 700;">Now Hiring</h4>
                    <p style="margin: 5px 0 0 0; opacity: 0.9;">Open for Applications</p>
                  <?php endif; ?>
                </div>

                <div style="border-top: 1px solid rgba(255,255,255,0.3); padding-top: 20px;">
                  <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div style="text-align: center;">
                      <p style="margin: 0 0 8px 0; opacity: 0.85; font-size: 12px; text-transform: uppercase; letter-spacing: 0.5px;">Closing Date</p>
                      <h6 style="margin: 0; font-size: 16px; font-weight: 600;"><?php echo $closingDate->format('d M'); ?></h6>
                      <p style="margin: 5px 0 0 0; font-size: 11px; opacity: 0.8;"><?php echo $closingDate->format('Y'); ?></p>
                    </div>
                    <?php if (!$isClosed): ?>
                    <div style="text-align: center;">
                      <p style="margin: 0 0 8px 0; opacity: 0.85; font-size: 12px; text-transform: uppercase; letter-spacing: 0.5px;">Days Left</p>
                      <h6 style="margin: 0; font-size: 16px; font-weight: 600;"><?php echo $daysUntilClosing; ?></h6>
                      <p style="margin: 5px 0 0 0; font-size: 11px; opacity: 0.8;">to apply</p>
                    </div>
                    <?php endif; ?>
                  </div>
                </div>
              </div>

              

              <!-- Other Open Positions -->
              <?php if ($recentVacancies): ?>
              <div class="sidebar-box" style="background: white; border: 1px solid #e0e0e0; padding: 20px; border-radius: 8px;">
                <h6 style="color: #007b40; margin: 0 0 18px 0; font-weight: 700; font-size: 14px; text-transform: uppercase; letter-spacing: 0.5px;">
                  <i class="fas fa-bookmark" style="margin-right: 8px;"></i>Other Positions
                </h6>
                <ul style="list-style: none; padding: 0; margin: 0; display: flex; flex-direction: column; gap: 12px;">
                  <?php foreach ($recentVacancies as $recent): 
                    $recClosingDate = new DateTime($recent['closing_date']);
                    $recIsClosed = $today > $recClosingDate;
                  ?>
                  <li style="border-bottom: 1px solid #f0f0f0; padding-bottom: 12px;">
                    <a href="vacancy-detail.php?id=<?php echo $recent['vacancy_id']; ?>&link=<?php echo $recent['link']; ?>" style="text-decoration: none; color: inherit; transition: all 0.3s ease; display: block; padding: 0; border-radius: 4px;">
                      <div style="display: flex; gap: 12px; align-items: flex-start;">
                        <div style="background: #f0f7f4; padding: 10px 12px; border-radius: 6px; flex-shrink: 0;">
                          <i class="fas fa-briefcase" style="color: #007b40; font-size: 16px;"></i>
                        </div>
                        <div style="flex: 1; min-width: 0;">
                          <h6 style="margin: 0 0 6px 0; font-weight: 600; color: #007b40; font-size: 13px; line-height: 1.4;">
                            <?php echo htmlspecialchars(substr($recent['job_title'], 0, 45)); ?>
                            <?php if (strlen($recent['job_title']) > 45) echo '...'; ?>
                          </h6>
                          <div style="display: flex; justify-content: space-between; align-items: center; gap: 8px;">
                            <span style="font-size: 11px; color: #999;">
                              <i class="fas fa-calendar-alt" style="margin-right: 4px;"></i>
                              <?php echo $recClosingDate->format('d M'); ?>
                            </span>
                            <span style="background: <?php echo $recIsClosed ? '#f8d7da' : '#d4edda'; ?>; color: <?php echo $recIsClosed ? '#721c24' : '#155724'; ?>; padding: 2px 8px; border-radius: 4px; font-size: 9px; font-weight: 600; text-transform: uppercase;">
                              <?php echo $recIsClosed ? 'Closed' : 'Open'; ?>
                            </span>
                          </div>
                        </div>
                      </div>
                    </a>
                  </li>
                  <?php endforeach; ?>
                </ul>
              </div>
              <?php endif; ?>
              
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End Single Vacancy Section -->

<?php include_once('layout/footer.php'); ?>
