<?php 
include_once('layout/header.php');

// Get search and category filters
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$category = isset($_GET['category']) ? trim($_GET['category']) : '';

// Build where conditions
$conditions = array('where' => 'a.status = 1 AND a.job_category = b.category_id', 'order_by' => 'a.date_posted DESC');

// Fetch vacancies
$vacancies = $con->getRows('vacancies a, job_categories b', $conditions);
$vacancyCategories = [];

if ($vacancies) {
    // Apply search and category filters
    $filtered = [];
    foreach ($vacancies as $vacancy) {
        $matchesSearch = true;
        $matchesCategory = true;
        
        if (!empty($search)) {
            $searchLower = strtolower($search);
            $matchesSearch = (
                strpos(strtolower($vacancy['job_title']), $searchLower) !== false ||
                strpos(strtolower($vacancy['job_description']), $searchLower) !== false
            );
        }
        
        if (!empty($category)) {
            $matchesCategory = ($vacancy['job_category'] == $category);
        }
        
        if ($matchesSearch && $matchesCategory) {
            $filtered[] = $vacancy;
            if (!in_array($vacancy['job_category'], $vacancyCategories)) {
                $vacancyCategories[] = $vacancy['job_category'];
            }
        }
    }
    $vacancies = $filtered;
} else {
    // Extract categories from all vacancies if search/filter didn't match
    $allVacancies = $con->getRows('vacancies', array('where' => 'status = 1'));
    if ($allVacancies) {
        foreach ($allVacancies as $v) {
            if (!in_array($v['job_category'], $vacancyCategories)) {
                $vacancyCategories[] = $v['job_category'];
            }
        }
    }
}

sort($vacancyCategories);
?>
    <!--End Page Header-->
    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">Career Opportunities</h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item active">vacancies</li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->
    <!-- Start Vacancies List Section -->
    <section class="vacancies-section mega-section">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="vacancies-header" style="margin-bottom: 30px;">
              <h2 style="color: #007b40; margin-bottom: 10px;">Career Opportunities</h2>
              <p style="color: #666;">Join our growing team. Browse available positions below.</p>
            </div>

            <div class="vacancies-list-container" style="background: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); overflow: hidden;">
              <!-- Search/Filter Bar -->
              <div style="padding: 25px; background-color: #f9f9f9; border-bottom: 1px solid #eee;">
                <div class="row" style="align-items: center;">
                  <div class="col-md-8">
                    <form method="GET" action="" style="display: flex; gap: 10px;">
                      <input type="text" name="search" class="form-control" placeholder="Search by job title or keywords..." value="<?php echo htmlspecialchars($search); ?>" style="flex: 1;">
                      <button type="submit" class="btn" style="background-color: #007b40; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer;">
                        <i class="fas fa-search"></i> Search
                      </button>
                    </form>
                  </div>
                  <div class="col-md-4 text-end">
                    <span style="color: #666; font-size: 14px; font-weight: 600;">
                      <?php echo count($vacancies); ?> Position<?php echo count($vacancies) !== 1 ? 's' : ''; ?>
                    </span>
                  </div>
                </div>
              </div>

              <!-- Vacancies List -->
              <div id="vacanciesContainer" style="padding: 0;">
                <?php if (empty($vacancies)): ?>
                  <div style="padding: 40px; text-align: center;">
                    <i class="fas fa-inbox" style="font-size: 48px; color: #ddd; margin-bottom: 15px; display: block;"></i>
                    <p style="color: #999; font-size: 16px;">No vacancies found. Please check back soon for new opportunities.</p>
                  </div>
                <?php else: ?>
                  <?php foreach ($vacancies as $vacancy):
                    $closingDate = new DateTime($vacancy['closing_date']);
                    $today = new DateTime();
                    $isClosed = $closingDate < $today;
                    $daysUntil = $today->diff($closingDate)->days;
                  ?>
                  <div style="padding: 20px 25px; border-bottom: 1px solid #eee; transition: background-color 0.2s ease;" 
                       onmouseover="this.style.backgroundColor='#f9f9f9';" 
                       onmouseout="this.style.backgroundColor='white';">
                    <div class="row" style="align-items: center;">
                      <div class="col-12 col-lg-6" style="margin-bottom: 15px; margin-bottom: 0;">
                        <a href="vacancy-detail.php?id=<?php echo $vacancy['vacancy_id']; ?>&link=<?php echo $vacancy['link']; ?>" style="text-decoration: none; color: inherit;">
                          <h5 style="margin: 0 0 8px 0; color: #007b40; font-weight: 600; font-size: 1.1rem;">
                            <?php echo htmlspecialchars($vacancy['job_title']); ?>
                          </h5>
                        </a>
                        <div style="display: flex; gap: 15px; flex-wrap: wrap; align-items: center;">
                          <span style="display: flex; align-items: center; gap: 6px; color: #666; font-size: 13px;">
                            <i class="fas fa-briefcase" style="color: #007b40;"></i>
                            <?php echo htmlspecialchars($vacancy['category']); ?>
                          </span>
                          <span style="display: flex; align-items: center; gap: 6px; color: #666; font-size: 13px;">
                            <i class="fas fa-calendar-alt" style="color: #007b40;"></i>
                            Posted: <?php echo $con->formatDate($vacancy['date_posted']); ?>
                          </span>
                        </div>
                      </div>
                      <div class="col-12 col-lg-3" style="margin-bottom: 15px;">
                        <div style="display: flex; flex-direction: column; gap: 8px;">
                          <div style="font-size: 13px; color: #666;">
                            <strong>Closing Date:</strong> <?php echo $closingDate->format('d M, Y'); ?>
                          </div>
                          <?php if (!$isClosed): ?>
                            <div style="font-size: 12px; color: #007b40;">
                              <i class="fas fa-hourglass-end"></i> <?php echo $daysUntil; ?> days remaining
                            </div>
                          <?php endif; ?>
                        </div>
                      </div>
                      <div class="col-12 col-lg-3" style="text-align: right;">
                        <div style="display: flex; gap: 10px; justify-content: flex-end; align-items: center;">
                          <?php if ($isClosed): ?>
                            <span style="background: #dc3545; color: white; padding: 6px 14px; border-radius: 4px; font-size: 11px; font-weight: 600;">CLOSED</span>
                          <?php else: ?>
                            <span style="background: #007b40; color: white; padding: 6px 14px; border-radius: 4px; font-size: 11px; font-weight: 600;">OPEN</span>
                          <?php endif; ?>
                          <a href="vacancy-detail.php?id=<?php echo $vacancy['vacancy_id']; ?>&link=<?php echo $vacancy['link']; ?>" class="btn btn-sm" style="background-color: #007b40; color: white; border: none; padding: 8px 16px; border-radius: 4px; text-decoration: none; font-size: 12px; white-space: nowrap;">
                            <i class="fas fa-arrow-right"></i> View Details
                          </a>
                        </div>
                      </div>
                    </div>
                  </div>
                  <?php endforeach; ?>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End Vacancies List Section-->
    
<?php include_once('layout/footer.php'); ?>
