<<?php include_once('layout/header.php'); ?>

<style>
  .event-card {
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
  }

  .event-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 12px 24px rgba(0, 123, 64, 0.15);
  }

  .event-card .event-image {
    position: relative;
    overflow: hidden;
    height: 240px;
  }

  .event-card .event-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s ease;
  }

  .event-card:hover .event-image img {
    transform: scale(1.05);
  }

  .event-date-badge {
    position: absolute;
    top: 15px;
    left: 15px;
    background: rgba(0, 123, 64, 0.95);
    color: white;
    padding: 12px 16px;
    border-radius: 6px;
    text-align: center;
    z-index: 10;
    backdrop-filter: blur(10px);
  }

  .event-date-badge .day {
    font-size: 24px;
    font-weight: 700;
    display: block;
    line-height: 1;
  }

  .event-date-badge .month {
    font-size: 11px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-top: 4px;
  }

  .event-status-badge {
    position: absolute;
    top: 15px;
    right: 15px;
    background: rgba(255, 255, 255, 0.95);
    color: #007b40;
    padding: 8px 12px;
    border-radius: 4px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    display: flex;
    align-items: center;
    gap: 5px;
    backdrop-filter: blur(10px);
  }

  .event-overlay {
    position: absolute;
    inset: 0;
    background: rgba(0, 123, 64, 0);
    transition: background 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .event-card:hover .event-overlay {
    background: rgba(0, 0, 0, 0.3);
  }

  .event-card .event-content {
    padding: 20px;
    background: white;
  }

  .event-card .event-title {
    font-size: 16px;
    font-weight: 700;
    color: #007b40;
    margin: 0 0 12px 0;
    line-height: 1.4;
    height: 2.8em;
    overflow: hidden;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
  }

  .event-card .event-meta {
    display: flex;
    flex-direction: column;
    gap: 10px;
    margin-bottom: 15px;
    padding-bottom: 15px;
    border-bottom: 1px solid #f0f0f0;
    font-size: 13px;
    color: #666;
  }

  .event-card .event-meta-item {
    display: flex;
    align-items: center;
    gap: 8px;
  }

  .event-card .event-meta-item i {
    color: #007b40;
    width: 14px;
  }

  .event-card .event-details-btn {
    display: inline-block;
    background-color: #007b40;
    color: white;
    padding: 10px 16px;
    border-radius: 4px;
    text-decoration: none;
    font-size: 13px;
    font-weight: 600;
    transition: all 0.3s ease;
    border: 2px solid #007b40;
  }

  .event-card .event-details-btn:hover {
    background-color: #005a2f;
    border-color: #005a2f;
    text-decoration: none;
  }
</style>

<!--End Page Header-->
<!-- Start inner Page hero-->
<section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
  <div class="overlay-color"></div>
  <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
    <div class="container">
      <div class="row">
        <div class="col-12 hero-text-area ">
          <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">Upcoming Events</h1>
          <nav aria-label="breadcrumb ">
            <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
              <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
              <li class="breadcrumb-item active">Upcoming Events</li>
            </ul>
          </nav>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- End inner Page hero-->

<!-- Start Events Section -->
<section class="events-section mega-section">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div style="margin-bottom: 40px; text-align: center;">
          <h2 style="color: #007b40; margin-bottom: 15px; font-size: 2.2rem; font-weight: 700;">Our Upcoming Events</h2>
          <p style="color: #666; max-width: 600px; margin: 0 auto; font-size: 16px;">
            Stay informed about important events and meetings. Mark your calendar and don't miss out on these important occasions.
          </p>
        </div>

        <?php
          $events = $con->getRows('events', array('where' => 'status = 1', 'order_by' => 'date ASC'));
          $today = new DateTime();
        ?>

        <?php if (!empty($events)): ?>
          <div class="row">
            <?php foreach ($events as $event):
              $eventDate = new DateTime($event['date']);
              $daysUntil = $today->diff($eventDate)->days;
              $isPast = $eventDate < $today;
              $isToday = $eventDate->format('Y-m-d') === $today->format('Y-m-d');
            ?>
            <div class="col-12 col-md-6 col-lg-4" style="margin-bottom: 30px;">
              <div class="event-card">
                <!-- Event Image -->
                <div class="event-image">
                  <img src="assets/uploads/events/thumbs/<?php echo htmlspecialchars($event['thumb']); ?>" alt="<?php echo htmlspecialchars($event['title']); ?>">
                  
                  <!-- Date Badge -->
                  <div class="event-date-badge">
                    <span class="day"><?php echo $eventDate->format('d'); ?></span>
                    <span class="month"><?php echo $eventDate->format('M'); ?></span>
                  </div>

                  <!-- Status Badge -->
                  <div class="event-status-badge">
                    <?php if ($isPast): ?>
                      <i class="fas fa-calendar-times"></i> Past Event
                    <?php elseif ($isToday): ?>
                      <i class="fas fa-calendar-check"></i> Today
                    <?php else: ?>
                      <i class="fas fa-hourglass-end"></i> <?php echo $daysUntil; ?> days
                    <?php endif; ?>
                  </div>

                  <!-- Overlay -->
                  <div class="event-overlay">
                    <a href="event-details.php?event=<?php echo $event['event_id']; ?>" style="display: inline-flex; align-items: center; justify-content: center; width: 50px; height: 50px; background: white; border-radius: 50%; color: #007b40; font-size: 20px; text-decoration: none; transition: all 0.3s ease;"
                       onmouseover="this.style.transform='scale(1.1)'; this.style.backgroundColor='#007b40'; this.style.color='white';"
                       onmouseout="this.style.transform='scale(1)'; this.style.backgroundColor='white'; this.style.color='#007b40';">
                      <i class="fas fa-arrow-right"></i>
                    </a>
                  </div>
                </div>

                <!-- Event Content -->
                <div class="event-content">
                  <h4 class="event-title"><?php echo htmlspecialchars($event['title']); ?></h4>

                  <div class="event-meta">
                    <div class="event-meta-item">
                      <i class="fas fa-map-marker-alt"></i>
                      <span><?php echo htmlspecialchars($event['venue']); ?></span>
                    </div>
                    <div class="event-meta-item">
                      <i class="fas fa-calendar-alt"></i>
                      <span><?php echo $eventDate->format('d F, Y'); ?></span>
                    </div>
                  </div>

                  <a href="event-details.php?event=<?php echo $event['event_id']; ?>" class="event-details-btn">
                    <i class="fas fa-arrow-right" style="margin-right: 6px;"></i>View Details
                  </a>
                </div>
              </div>
            </div>
            <?php endforeach; ?>
          </div>
        <?php else: ?>
          <div style="text-align: center; padding: 60px 20px;">
            <i class="fas fa-calendar-times" style="font-size: 64px; color: #ddd; margin-bottom: 20px; display: block;"></i>
            <h4 style="color: #999; margin-bottom: 10px; font-size: 1.3rem;">No Upcoming Events</h4>
            <p style="color: #bbb; font-size: 15px;">There are no upcoming events at the moment. Please check back soon for new events.</p>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</section>
<!-- End Events Section-->

<?php include_once('layout/footer.php'); ?>