<?php include_once('layout/header.php'); ?>
<?php
// Fetch testimonials from database
$testimonials = $con->getRows('testimonials', array('order_by' => 'date_created DESC'));
$totalTestimonials = $testimonials ? count($testimonials) : 0;
?>
	
    <!--End Page Header-->
    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">Member Success Stories</h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="#0"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item active">testimonials</li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->

    <!-- Start Testimonials Grid Section -->
    <section class="testimonials-section mega-section" id="testimonials-main" style="padding: 80px 0; background: #f9f9f9;">
      <div class="container">
        <!-- Section Header -->
        <div class="section-heading center-heading" style="margin-bottom: 60px;">
          <h2 class="section-title wow fadeInUp" data-wow-delay=".2s" style="font-size: 42px; color: #333; margin-bottom: 20px;">What Our Members Say About Us<span class="title-design-element "></span></h2>
          <p class="section-description wow fadeInUp" data-wow-delay=".4s" style="font-size: 16px; color: #666; max-width: 600px; margin: 0 auto; line-height: 1.8;">Our members are at the heart of everything we do. Their success stories inspire us to continually improve our services and support their financial goals.</p>
          <div class="line line-on-center wow fadeIn" data-wow-delay=".7s" style="margin-top: 30px;"></div>
        </div>

        <!-- Stats Row -->
        <div class="row text-center mb-5">
          <div class="col-12 col-md-4 mb-3 mb-md-0">
            <div class="stat-box wow fadeInUp" data-wow-delay="0.2s">
              <h3 style="font-size: 36px; color: #007b40; font-weight: 700; margin-bottom: 5px;"><?php echo $totalTestimonials; ?>+</h3>
              <p style="font-size: 14px; color: #666;">Satisfied Members</p>
            </div>
          </div>
          <div class="col-12 col-md-4 mb-3 mb-md-0">
            <div class="stat-box wow fadeInUp" data-wow-delay="0.3s">
              <h3 style="font-size: 36px; color: #007b40; font-weight: 700; margin-bottom: 5px;">5<i class="fas fa-star" style="font-size: 20px; color: #ffc107;"></i></h3>
              <p style="font-size: 14px; color: #666;">Average Rating</p>
            </div>
          </div>
          <div class="col-12 col-md-4">
            <div class="stat-box wow fadeInUp" data-wow-delay="0.4s">
              <h3 style="font-size: 36px; color: #007b40; font-weight: 700; margin-bottom: 5px;">100%</h3>
              <p style="font-size: 14px; color: #666;">Recommend Us</p>
            </div>
          </div>
        </div>

        <!-- Testimonials Grid -->
        <div class="row mt-5">
          <?php
          if ($testimonials) {
            foreach ($testimonials as $index => $testimonial) {
              $rating = isset($testimonial['rating']) ? intval($testimonial['rating']) : 5;
              $stars = '';
              for ($i = 1; $i <= 5; $i++) {
                $stars .= $i <= $rating ? '<i class="fas fa-star" style="color: #ffc107; font-size: 14px;"></i>' : '<i class="fas fa-star" style="color: #e0e0e0; font-size: 14px;"></i>';
              }
              $delay = (0.15 + ($index * 0.08)) > 0.7 ? 0.7 : (0.15 + ($index * 0.08));
              ?>
          <div class="col-12 col-md-6 col-lg-4 mb-4">
            <div class="testimonial-card-modern wow fadeInUp" data-wow-delay="<?php echo $delay; ?>s" style="
              background: white;
              border-radius: 12px;
              padding: 30px;
              height: 100%;
              box-shadow: 0 2px 10px rgba(0,0,0,0.08);
              transition: all 0.3s ease;
              position: relative;
              overflow: hidden;
            " onmouseover="this.style.boxShadow='0 10px 30px rgba(0,123,64,0.15)'; this.style.transform='translateY(-5px)';" onmouseout="this.style.boxShadow='0 2px 10px rgba(0,0,0,0.08)'; this.style.transform='translateY(0)';">
              
              <!-- Quote Mark -->
              <div style="position: absolute; top: 15px; right: 20px; font-size: 50px; color: #007b40; opacity: 0.1;">
                <i class="fas fa-quote-left"></i>
              </div>

              <!-- Stars -->
              <div style="margin-bottom: 15px;">
                <?php echo $stars; ?>
              </div>

              <!-- Testimonial Text -->
              <p class="testimonial-text " style="
                font-size: 15px;
                line-height: 1.7;
                color: #555;
                margin-bottom: 25px;
                font-style: italic;
              "><?php echo htmlspecialchars($testimonial['testimonial_text']); ?></p>

              <!-- Divider -->
              <div style="width: 40px; height: 3px; background: #007b40; margin-bottom: 20px;"></div>

              <!-- Customer Info -->
              <div class="customer-info" style="display: flex; align-items: center; gap: 15px;">
                <img class="img-fluid rounded-circle" style="width: 50px; height: 50px; object-fit: cover; border: 3px solid #007b40;" src="<?php echo htmlspecialchars($testimonial['customer_image']); ?>" alt="<?php echo htmlspecialchars($testimonial['customer_name']); ?>">
                <div>
                  <p class="customer-name" style="font-weight: 700; font-size: 15px; color: #333; margin: 0;"><?php echo htmlspecialchars($testimonial['customer_name']); ?></p>
                  <p class="customer-role" style="font-size: 12px; color: #999; margin: 3px 0 0 0;"><?php echo htmlspecialchars($testimonial['customer_role']); ?></p>
                </div>
              </div>
            </div>
          </div>
              <?php
            }
          } else {
            ?>
          <div class="col-12 text-center">
            <p style="font-size: 18px; color: #666; padding: 40px 0;">No testimonials available yet. Be the first to share your experience!</p>
          </div>
            <?php
          }
          ?>
        </div>
      </div>
    </section>
    <!-- End Testimonials Grid Section -->

    <!-- Start CTA Section - Share Your Story -->
    <section class="cta-section" style="
      background: linear-gradient(135deg, #007b40 0%, #005a2e 100%);
      padding: 80px 0;
      position: relative;
      overflow: hidden;
    " id="cta-testimonial">
      <div class="overlay-pattern-image-bg" style="opacity: 0.1;"></div>
      <div class="container" style="position: relative; z-index: 2;">
        <div class="row align-items-center">
          <div class="col-12 col-lg-8">
            <h2 style="
              font-size: 36px;
              color: white;
              margin-bottom: 15px;
              font-weight: 700;
            " class="wow fadeInLeft" data-wow-delay="0.2s">Have a success story to share?</h2>
            <p style="
              font-size: 16px;
              color: rgba(255,255,255,0.9);
              margin-bottom: 0;
              line-height: 1.7;
            " class="wow fadeInLeft" data-wow-delay="0.4s;">We'd love to hear about your experience with Sunbird SACCO. Your testimonial helps inspire other members and strengthens our community.</p>
          </div>
          <div class="col-12 col-lg-4 text-lg-end mt-4 mt-lg-0">
            <a href="contact.php" class="btn-solid" style="
              background: white;
              color: #007b40;
              padding: 15px 40px;
              border-radius: 50px;
              font-weight: 600;
              text-decoration: none;
              display: inline-block;
              transition: all 0.3s ease;
              font-size: 16px;
            " onmouseover="this.style.transform='scale(1.05)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.2)';" onmouseout="this.style.transform='scale(1)'; this.style.boxShadow='none';" class="wow fadeInRight" data-wow-delay="0.2s">Share Your Story</a>
          </div>
        </div>
      </div>
    </section>
    <!-- End CTA Section -->

    <!-- Start  page-footer Section-->
    <?php include_once('layout/footer.php'); ?>