<?php 
include_once('layout/header.php');
// Fetch savings products from database
$savings = $con->getRows('savings_products', array('order_by' => 'product_id ASC'));
$totalSavings = $savings ? count($savings) : 0;
?>
    <!--End Page Header-->
    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">Our Savings Products</h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item active">Savings Products</li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->
    <!-- Start Savings Products Section -->
    <section class="savings-section mega-section" id="savings-main" style="padding: 80px 0; background: #f9f9f9;">
      <div class="container">
        <!-- Section Header -->
        <div class="section-heading center-heading" style="margin-bottom: 60px;">
          <h2 class="section-title wow fadeInUp" data-wow-delay=".2s" style="font-size: 42px; color: #333; margin-bottom: 20px;">Choose the Right Savings Plan for You<span class="title-design-element "></span></h2>
          <p class="section-description wow fadeInUp" data-wow-delay=".4s" style="font-size: 16px; color: #666; max-width: 700px; margin: 0 auto; line-height: 1.8;">Our savings products offer competitive returns and flexible terms. Whether you're saving for a specific goal or building long-term wealth, we have the right plan for you.</p>
          <div class="line line-on-center wow fadeIn" data-wow-delay=".7s" style="margin-top: 30px;"></div>
        </div>

        <!-- Stats Row -->
        <div class="row text-center mb-5">
          <div class="col-12 col-md-4 mb-3 mb-md-0">
            <div class="stat-box wow fadeInUp" data-wow-delay="0.2s">
              <h3 style="font-size: 36px; color: #007b40; font-weight: 700; margin-bottom: 5px;"><?php echo $totalSavings; ?></h3>
              <p style="font-size: 14px; color: #666;">Savings Products</p>
            </div>
          </div>
          <div class="col-12 col-md-4 mb-3 mb-md-0">
            <div class="stat-box wow fadeInUp" data-wow-delay="0.3s">
              <h3 style="font-size: 36px; color: #007b40; font-weight: 700; margin-bottom: 5px;">Competitive</h3>
              <p style="font-size: 14px; color: #666;">Interest Returns</p>
            </div>
          </div>
          <div class="col-12 col-md-4">
            <div class="stat-box wow fadeInUp" data-wow-delay="0.4s">
              <h3 style="font-size: 36px; color: #007b40; font-weight: 700; margin-bottom: 5px;">Secure</h3>
              <p style="font-size: 14px; color: #666;">Your Savings</p>
            </div>
          </div>
        </div>

        <!-- Savings Products Grid -->
        <div class="row mt-5">
          <?php
          if ($savings) {
            foreach ($savings as $index => $product) {
              $delay = (0.15 + ($index * 0.08)) > 0.7 ? 0.7 : (0.15 + ($index * 0.08));
              $product_id = isset($product['product_id']) ? $product['product_id'] : 0;
              $title = isset($product['title']) ? htmlspecialchars($product['title']) : 'Savings Product';
              $description = isset($product['description']) ? $product['description'] : '';
              ?>
          <div class="col-12 col-md-6 col-lg-4 mb-4">
            <div class="savings-card-modern wow fadeInUp" data-wow-delay="<?php echo $delay; ?>s" style="
              background: white;
              border-radius: 12px;
              padding: 35px;
              height: 100%;
              box-shadow: 0 2px 10px rgba(0,0,0,0.08);
              transition: all 0.3s ease;
              position: relative;
              overflow: hidden;
              border-top: 4px solid #007b40;
            " onmouseover="this.style.boxShadow='0 10px 30px rgba(0,123,64,0.15)'; this.style.transform='translateY(-5px)';" onmouseout="this.style.boxShadow='0 2px 10px rgba(0,0,0,0.08)'; this.style.transform='translateY(0)';">
              
              <!-- Product Icon Background -->
              <div style="
                position: absolute;
                top: -40px;
                right: -40px;
                width: 150px;
                height: 150px;
                background: rgba(0,123,64,0.05);
                border-radius: 50%;
              "></div>

              <!-- Product Icon -->
              <div style="
                font-size: 32px;
                color: #007b40;
                margin-bottom: 15px;
                position: relative;
                z-index: 2;
              ">
                <i class="fas fa-piggy-bank"></i>
              </div>

              <!-- Product Name -->
              <h3 style="
                font-size: 22px;
                font-weight: 700;
                color: #007b40;
                margin-bottom: 15px;
                position: relative;
                z-index: 2;
              "><?php echo $title; ?></h3>

              <!-- Product Description -->
              <p style="
                font-size: 14px;
                line-height: 1.7;
                color: #666;
                margin-bottom: 25px;
                position: relative;
                z-index: 2;
              "><?php 
                echo strlen($description) > 150 ? substr($description, 0, 150) . '...' : $description;
              ?></p>

              <!-- Benefits Preview -->
              <div style="
                background: #f5f5f5;
                border-radius: 8px;
                padding: 20px;
                margin-bottom: 25px;
                position: relative;
                z-index: 2;
              ">
                <ul style="list-style: none; padding: 0; margin: 0;">
                  <li style="display: flex; align-items: center; margin-bottom: 10px; font-size: 13px; color: #666;">
                    <i class="fas fa-check" style="color: #007b40; margin-right: 8px; font-weight: bold;"></i>
                    Easy to open
                  </li>
                  <li style="display: flex; align-items: center; margin-bottom: 10px; font-size: 13px; color: #666;">
                    <i class="fas fa-check" style="color: #007b40; margin-right: 8px; font-weight: bold;"></i>
                    Flexible withdrawals
                  </li>
                  <li style="display: flex; align-items: center; font-size: 13px; color: #666;">
                    <i class="fas fa-check" style="color: #007b40; margin-right: 8px; font-weight: bold;"></i>
                    Competitive returns
                  </li>
                </ul>
              </div>

              <!-- Action Button -->
              <a href="savings-detail.php?id=<?php echo $product_id; ?>" style="
                display: block;
                text-align: center;
                background: #007b40;
                color: white;
                padding: 12px 20px;
                border-radius: 50px;
                font-weight: 600;
                text-decoration: none;
                transition: all 0.3s ease;
                font-size: 14px;
                position: relative;
                z-index: 2;
              " onmouseover="this.style.background='#005a2e';" onmouseout="this.style.background='#007b40';">
                Learn More <i class="fas fa-arrow-right" style="margin-left: 8px;"></i>
              </a>
            </div>
          </div>
              <?php
            }
          } else {
            ?>
          <div class="col-12 text-center">
            <p style="font-size: 18px; color: #666; padding: 40px 0;">No savings products available at the moment.</p>
          </div>
            <?php
          }
          ?>
        </div>
      </div>
    </section>
    <!-- End Savings Products Section -->
    <!-- Start CTA Section - Open Savings Account -->
    <section class="cta-section" style="
      background: linear-gradient(135deg, #007b40 0%, #005a2e 100%);
      padding: 80px 0;
      position: relative;
      overflow: hidden;
    " id="cta-savings">
      <div class="overlay-pattern-image-bg" style="opacity: 0.1;"></div>
      <div class="container" style="position: relative; z-index: 2;">
        <div class="row align-items-center">
          <div class="col-12 col-lg-8">
            <h2 style="
              font-size: 36px;
              color: white;
              margin-bottom: 15px;
              font-weight: 700;
            " class="wow fadeInLeft" data-wow-delay="0.2s">Start Growing Your Savings Today</h2>
            <p style="
              font-size: 16px;
              color: rgba(255,255,255,0.9);
              margin-bottom: 0;
              line-height: 1.7;
            " class="wow fadeInLeft" data-wow-delay="0.4s;">Open a savings account with us and enjoy competitive returns. It's easy, secure, and your journey to financial growth starts here.</p>
          </div>
          <div class="col-12 col-lg-4 text-lg-end mt-4 mt-lg-0">
            <a href="savings.php#savings-main" class="btn-solid" style="
              background: white;
              color: #007b40;
              padding: 15px 40px;
              border-radius: 50px;
              font-weight: 600;
              text-decoration: none;
              display: inline-block;
              transition: all 0.3s ease;
              font-size: 16px;
            " onmouseover="this.style.transform='scale(1.05)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.2)';" onmouseout="this.style.transform='scale(1)'; this.style.boxShadow='none';">Explore Plans</a>
          </div>
        </div>
      </div>
    </section>
    <!-- End CTA Section -->

    <?php include_once('layout/footer.php'); ?>