<?php include_once('layout/header.php'); ?>
<?php
// Get savings product ID from URL
$product_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch specific savings product details
$product = $con->getRows('savings_products', array(
    'where' => array('product_id' => $product_id),
    'return_type' => 'single'
));

// If product not found, redirect to savings page
if (!$product) {
    header("Location: savings.php");
    exit;
}
?>

    <!--End Page Header-->
    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s"><?php echo htmlspecialchars($product['title']); ?></h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="savings.php">Savings Products</a></li>
                  <li class="breadcrumb-item active"><?php echo htmlspecialchars($product['title']); ?></li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->

    <!-- Start Savings Product Detail Section -->
    <section class="product-detail-section mega-section" style="padding: 80px 0; background: #f9f9f9;">
      <div class="container">
        <div class="row">
          <!-- Main Content -->
          <div class="col-12 col-lg-8">
            <!-- Product Overview -->
            <div class="product-overview-card" style="
              background: white;
              border-radius: 12px;
              padding: 40px;
              margin-bottom: 40px;
              box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            " data-wow-delay="0.2s">
              <h2 style="
                font-size: 32px;
                color: #007b40;
                margin-bottom: 20px;
                font-weight: 700;
              "><?php echo htmlspecialchars($product['title']); ?></h2>

              <div class="description-content" style="
                font-size: 15px;
                line-height: 1.8;
                color: #555;
                margin-bottom: 30px;
              ">
                <p><?php echo nl2br($product['description']); ?></p>
              </div>

            </div>

            <!-- Why Choose Us -->
            <div class="why-choose-card" style="
              background: white;
              border-radius: 12px;
              padding: 40px;
              box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            " data-wow-delay="0.4s">
              <h3 style="
                font-size: 22px;
                color: #333;
                margin-bottom: 30px;
                font-weight: 700;
              ">Why Choose This Savings Plan?</h3>

              <div class="row">
                <div class="col-12 col-md-6" class="wow fadeInUp" data-wow-delay="0.5s">
                  <div style="margin-bottom: 30px;">
                    <div style="
                      width: 60px;
                      height: 60px;
                      background: #f0f8f4;
                      border-radius: 50%;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                      margin: 0 auto 15px;
                    ">
                      <i class="fas fa-shield-alt" style="font-size: 24px; color: #007b40;"></i>
                    </div>
                    <h4 style="color: #333; margin-bottom: 10px; font-weight: 600; text-align: center;">Secure & Protected</h4>
                    <p style="color: #666; font-size: 14px; text-align: center;">Your funds are fully protected and insured for peace of mind</p>
                  </div>
                </div>

                <div class="col-12 col-md-6" class="wow fadeInUp" data-wow-delay="0.6s">
                  <div style="margin-bottom: 30px;">
                    <div style="
                      width: 60px;
                      height: 60px;
                      background: #f0f8f4;
                      border-radius: 50%;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                      margin: 0 auto 15px;
                    ">
                      <i class="fas fa-chart-line" style="font-size: 24px; color: #007b40;"></i>
                    </div>
                    <h4 style="color: #333; margin-bottom: 10px; font-weight: 600; text-align: center;">Strong Returns</h4>
                    <p style="color: #666; font-size: 14px; text-align: center;">Competitive interest rates that help your money grow</p>
                  </div>
                </div>

                <div class="col-12 col-md-6" class="wow fadeInUp" data-wow-delay="0.7s">
                  <div style="margin-bottom: 30px;">
                    <div style="
                      width: 60px;
                      height: 60px;
                      background: #f0f8f4;
                      border-radius: 50%;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                      margin: 0 auto 15px;
                    ">
                      <i class="fas fa-lock" style="font-size: 24px; color: #007b40;"></i>
                    </div>
                    <h4 style="color: #333; margin-bottom: 10px; font-weight: 600; text-align: center;">Privacy Guaranteed</h4>
                    <p style="color: #666; font-size: 14px; text-align: center;">Your personal information is kept confidential and secure</p>
                  </div>
                </div>

                <div class="col-12 col-md-6" class="wow fadeInUp" data-wow-delay="0.8s">
                  <div style="margin-bottom: 30px;">
                    <div style="
                      width: 60px;
                      height: 60px;
                      background: #f0f8f4;
                      border-radius: 50%;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                      margin: 0 auto 15px;
                    ">
                      <i class="fas fa-headset" style="font-size: 24px; color: #007b40;"></i>
                    </div>
                    <h4 style="color: #333; margin-bottom: 10px; font-weight: 600; text-align: center;">24/7 Support</h4>
                    <p style="color: #666; font-size: 14px; text-align: center;">Our team is always available to assist you</p>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Sidebar -->
          <div class="col-12 col-lg-4">
            <!-- Open Account Card -->
            <div class="open-account-card" style="
              background: white;
              border-radius: 12px;
              padding: 30px;
              margin-bottom: 30px;
              box-shadow: 0 2px 10px rgba(0,0,0,0.08);
              border-top: 4px solid #007b40;
            " data-wow-delay="0.2s">
              <h3 style="
                font-size: 18px;
                color: #333;
                margin-bottom: 20px;
                font-weight: 700;
                text-align: center;
              ">Ready to Get Started?</h3>

              <a href="membership_application.php" style="
                display: block;
                width: 100%;
                text-align: center;
                background: #007b40;
                color: white;
                padding: 14px;
                border-radius: 50px;
                font-weight: 600;
                text-decoration: none;
                transition: all 0.3s ease;
                font-size: 16px;
                margin-bottom: 12px;
              " onmouseover="this.style.background='#005a2e';" onmouseout="this.style.background='#007b40';">
                Open Account Now
              </a>

              <p style="
                text-align: center;
                font-size: 13px;
                color: #999;
                margin: 15px 0;
              ">Already a member? <a href="loan_application.php" style="color: #007b40; text-decoration: none; font-weight: 600;">Apply for a Loan Here</a></p>
            </div>

            

            <!-- Contact Support Card -->
            <div class="support-card" style="
              background: white;
              border-radius: 12px;
              padding: 25px;
              box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            " data-wow-delay="0.4s">
              <h4 style="
                font-size: 16px;
                color: #333;
                margin-bottom: 15px;
                font-weight: 700;
              "><i class="fas fa-question-circle" style="color: #007b40; margin-right: 8px;"></i>Have Questions?</h4>

              <p style="font-size: 14px; color: #666; margin-bottom: 15px;">Contact our support team for more information about this savings product.</p>

              <a href="contact.php" style="
                display: inline-block;
                color: #007b40;
                text-decoration: none;
                font-weight: 600;
                font-size: 14px;
              ">
                Contact Us <i class="fas fa-arrow-right" style="margin-left: 5px;"></i>
              </a>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End Savings Product Detail Section -->

    <!-- Start CTA Section -->
    <section class="cta-section" style="
      background: linear-gradient(135deg, #007b40 0%, #005a2e 100%);
      padding: 60px 0;
      position: relative;
      overflow: hidden;
    ">
      <div class="overlay-pattern-image-bg" style="opacity: 0.1;"></div>
      <div class="container" style="position: relative; z-index: 2;">
        <div class="row align-items-center">
          <div class="col-12 col-lg-8">
            <h2 style="
              font-size: 32px;
              color: white;
              margin-bottom: 15px;
              font-weight: 700;
            " class="wow fadeInLeft" data-wow-delay="0.2s">Ready to Grow Your Savings?</h2>
            <p style="
              font-size: 15px;
              color: rgba(255,255,255,0.9);
              margin-bottom: 0;
              line-height: 1.7;
            " class="wow fadeInLeft" data-wow-delay="0.4s;">Join thousands of members who are growing their wealth with us. Open your account today and start earning.</p>
          </div>
          <div class="col-12 col-lg-4 text-lg-end mt-4 mt-lg-0">
            <a href="membership_application.php" class="btn-solid" style="
              background: white;
              color: #007b40;
              padding: 15px 40px;
              border-radius: 50px;
              font-weight: 600;
              text-decoration: none;
              display: inline-block;
              transition: all 0.3s ease;
              font-size: 16px;
            " onmouseover="this.style.transform='scale(1.05)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.2)';" onmouseout="this.style.transform='scale(1)'; this.style.boxShadow='none';">Get Started Now</a>
          </div>
        </div>
      </div>
    </section>
    <!-- End CTA Section -->

    <?php include_once('layout/footer.php'); ?>
