<?php include_once('layout/header.php'); ?>
    <!--End Page Header-->
    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">SACCO Documents</h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item active">documents</li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->
    <!-- Start Documents List Section-->
    <section class="documents-section mega-section">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="documents-header" style="margin-bottom: 30px;">
              <h2 style="color: #007b40; margin-bottom: 10px;">SACCO Documents & Resources</h2>
              <p style="color: #666;">Access important documents and resources related to our SACCO</p>
            </div>

            <div class="documents-list-container" style="background: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); overflow: hidden;">
              <!-- Search/Filter Bar -->
              <div style="padding: 20px; background-color: #f9f9f9; border-bottom: 1px solid #eee;">
                <div class="row">
                  <div class="col-md-6">
                    <input type="text" id="searchDocuments" class="form-control" placeholder="Search documents...">
                  </div>
                  <div class="col-md-6 text-end">
                    <span id="documentCount" style="color: #666; font-size: 14px;">Loading...</span>
                  </div>
                </div>
              </div>

              <!-- Documents Table/List -->
              <div id="documentsContainer" style="padding: 20px;">
                <div class="text-center" style="padding: 40px;">
                  <div class="spinner-border" role="status" style="color: #007b40;">
                    <span class="sr-only">Loading...</span>
                  </div>
                  <p style="margin-top: 15px; color: #666;">Loading documents...</p>
                </div>
              </div>

              <!-- Empty State -->
              <div id="emptyState" style="display: none; padding: 40px; text-align: center;">
                <i class="fas fa-inbox" style="font-size: 48px; color: #ddd; margin-bottom: 15px; display: block;"></i>
                <p style="color: #999; font-size: 16px;">No documents found matching your search.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End Documents List Section-->
    <?php include_once('layout/footer.php'); ?>
    
    <script>
      let allDocuments = [];

      // Determine file icon and color based on file extension
      function getFileIcon(filename) {
        const ext = filename.split('.').pop().toLowerCase();
        const iconMap = {
          'pdf': { icon: 'fas fa-file-pdf', color: '#dc3545' },
          'doc': { icon: 'fas fa-file-word', color: '#0056b3' },
          'docx': { icon: 'fas fa-file-word', color: '#0056b3' },
          'xls': { icon: 'fas fa-file-excel', color: '#117a65' },
          'xlsx': { icon: 'fas fa-file-excel', color: '#117a65' },
          'ppt': { icon: 'fas fa-file-powerpoint', color: '#e67e22' },
          'pptx': { icon: 'fas fa-file-powerpoint', color: '#e67e22' },
          'jpg': { icon: 'fas fa-file-image', color: '#9b59b6' },
          'jpeg': { icon: 'fas fa-file-image', color: '#9b59b6' },
          'png': { icon: 'fas fa-file-image', color: '#9b59b6' },
          'gif': { icon: 'fas fa-file-image', color: '#9b59b6' },
          'txt': { icon: 'fas fa-file-text', color: '#666' },
          'zip': { icon: 'fas fa-file-archive', color: '#8B4513' },
          'rar': { icon: 'fas fa-file-archive', color: '#8B4513' }
        };
        return iconMap[ext] || { icon: 'fas fa-file', color: '#666' };
      }

      // Load SACCO documents via AJAX
      document.addEventListener('DOMContentLoaded', function() {
        loadDocuments('document');
        
        // Search functionality
        document.getElementById('searchDocuments').addEventListener('keyup', function(e) {
          filterDocuments(e.target.value);
        });
      });

      function loadDocuments(reportType) {
        fetch('admin/user_accounts/editors/get-reports.php?type=' + reportType)
          .then(response => response.json())
          .then(data => {
            allDocuments = data;
            displayDocuments(data);
          })
          .catch(error => {
            console.error('Error loading documents:', error);
            document.getElementById('documentsContainer').innerHTML = '<div class="alert alert-danger" style="margin: 0;"><i class="fas fa-exclamation-circle"></i> Error loading documents. Please try again later.</div>';
          });
      }

      function filterDocuments(searchTerm) {
        const filtered = allDocuments.filter(document => 
          document.title.toLowerCase().includes(searchTerm.toLowerCase())
        );
        displayDocuments(filtered);
      }

      function displayDocuments(documents) {
        const container = document.getElementById('documentsContainer');
        const emptyState = document.getElementById('emptyState');
        const documentCount = document.getElementById('documentCount');
        
        if (!documents || documents.length === 0) {
          container.style.display = 'none';
          emptyState.style.display = 'block';
          documentCount.textContent = '0 Documents';
          return;
        }

        container.style.display = 'block';
        emptyState.style.display = 'none';
        documentCount.textContent = documents.length + ' Document' + (documents.length !== 1 ? 's' : '');

        let html = `
          <div style="overflow-x: auto;">
            <table class="table table-hover" style="margin-bottom: 0; border: none;">
              <thead style="background-color: #007b40; color: white; border: none;">
                <tr>
                  <th style="padding: 15px; border: none;">Document Title</th>
                  <th style="padding: 15px; border: none; width: 150px; text-align: center;">Date</th>
                  <th style="padding: 15px; border: none; width: 150px; text-align: center;">Action</th>
                </tr>
              </thead>
              <tbody>
        `;

        documents.forEach((document, index) => {
          const date = new Date(document.date);
          const formattedDate = date.toLocaleDateString('en-US', { 
            year: 'numeric', 
            month: 'short', 
            day: 'numeric' 
          });
          const fileInfo = getFileIcon(document.file);
          const ext = document.file.split('.').pop().toUpperCase();

          html += `
            <tr style="border-bottom: 1px solid #eee; hover: background-color: #f9f9f9;">
              <td style="padding: 15px; vertical-align: middle;">
                <div style="display: flex; align-items: center;">
                  <i class="${fileInfo.icon}" style="color: ${fileInfo.color}; font-size: 20px; margin-right: 12px;"></i>
                  <div>
                    <p style="margin: 0; font-weight: 500; color: #333;">${document.title}</p>
                    <small style="color: #999;">${ext} File</small>
                  </div>
                </div>
              </td>
              <td style="padding: 15px; text-align: center; vertical-align: middle;">
                <small style="color: #666;">${formattedDate}</small>
              </td>
              <td style="padding: 15px; text-align: center; vertical-align: middle;">
                <a href="assets/uploads/reports/${encodeURIComponent(document.file)}" 
                   download="${document.file}" 
                   class="btn btn-sm" 
                   style="background-color: #007b40; color: white; border: none; padding: 8px 16px; border-radius: 4px; text-decoration: none; display: inline-flex; align-items: center; gap: 6px; font-size: 12px;">
                  <i class="fas fa-download"></i> Download
                </a>
              </td>
            </tr>
          `;
        });

        html += `
              </tbody>
            </table>
          </div>
        `;

        container.innerHTML = html;
      }
    </script>