<?php include_once('layout/header.php'); ?>

<?php
$blog_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($blog_id === 0) {
    header('Location: latest_news.php');
    exit;
}

// Fetch blog post details using DB class
$post = $con->getRows('blog_posts a, blog_categories b', array(
    'where' => array('blog_id' => $blog_id, 'status' => 1, 'a.blog_category = b.category_id'),
    'return_type' => 'single'
));

if (!$post) {
    header('Location: latest_news.php');
    exit;
}

$postDate = new DateTime($post['date_posted']);

// Get recent posts for sidebar
$recentPosts = $con->getRows('blog_posts', array(
    'where' => 'status = 1 AND blog_id != ' . $blog_id,
    'order_by' => 'date_posted DESC',
    'limit' => 4
));

// Get related posts (same category, excluding current)
$relatedPosts = $con->getRows('blog_posts', array(
    'where' => 'status = 1 AND blog_category = "' . $post['blog_category'] . '" AND blog_id != ' . $blog_id,
    'order_by' => 'date_posted DESC',
    'limit' => 3
));
?>

    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">Blog Article</h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="latest_news.php">Blog</a></li>
                  <li class="breadcrumb-item active"><?php echo htmlspecialchars(substr($post['blog_title'], 0, 50)); ?></li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->

    <!-- Start Post Details Section -->
    <section class="post-details-section mega-section">
      <div class="container">
        <div class="row">
          <div class="col-12 col-lg-8">
            <!-- Post Article -->
            <article class="post-article">
              <!-- Post Header Image -->
              <div class="post-hero-image" style="margin-bottom: 30px; border-radius: 8px; overflow: hidden; box-shadow: 0 4px 12px rgba(0, 123, 64, 0.15);">
                <img src="assets/uploads/news/images/<?php echo htmlspecialchars($post['post_image']); ?>" alt="<?php echo htmlspecialchars($post['blog_title']); ?>" style="width: 100%; height: auto; display: block;">
              </div>

              <!-- Post Header -->
              <div class="post-header" style="margin-bottom: 30px; padding-bottom: 25px; border-bottom: 2px solid #f0f0f0;">
                <div style="display: flex; gap: 15px; align-items: flex-start; margin-bottom: 20px;">
                  <div style="background: linear-gradient(135deg, #007b40 0%, #005a2f 100%); color: white; padding: 20px; border-radius: 8px; flex-shrink: 0;">
                    <i class="fas fa-newspaper" style="font-size: 28px;"></i>
                  </div>
                  <div style="flex: 1;">
                    <h1 style="color: #007b40; margin: 0 0 10px 0; font-size: 2.2rem; line-height: 1.3; font-weight: 700;">
                      <?php echo htmlspecialchars($post['blog_title']); ?>
                    </h1>
                    <p style="margin: 0; color: #999; font-size: 14px;">
                      <i class="fas fa-folder-open" style="margin-right: 6px;"></i><?php echo htmlspecialchars($post['category']); ?> • 
                      <?php echo $con->formatDate($post['date_posted']); ?>
                    </p>
                  </div>
                </div>
              </div>

              <!-- Post Content -->
              <div class="post-content" style="line-height: 1.9; color: #444; font-size: 1rem; margin-bottom: 40px;">
                <h3 style="color: #007b40; margin: 0 0 20px 0; font-size: 1.6rem; font-weight: 700;">Article Content</h3>
                <?php echo $post['blog_content']; ?>
              </div>


              <!-- Post Footer -->
              <div class="post-footer" style="background: linear-gradient(135deg, #f0f7f4 0%, #ffffff 100%); padding: 30px; border-radius: 8px; border-left: 4px solid #007b40; box-shadow: 0 2px 8px rgba(0, 123, 64, 0.08);">
                <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 20px;">
                  <div>
                    <h5 style="margin: 0 0 10px 0; color: #007b40; font-size: 1.1rem; font-weight: 600;">
                      <i class="fas fa-info-circle" style="margin-right: 8px;"></i>Article Information
                    </h5>
                    <p style="margin: 0; color: #666; font-size: 14px; line-height: 1.6;">
                      This article was published on <?php echo $postDate->format('d F, Y'); ?> in the <?php echo htmlspecialchars($post['category']); ?> category.
                    </p>
                  </div>
                  <a href="latest_news.php" class="btn" style="background-color: #007b40; color: white; border: none; padding: 12px 28px; border-radius: 4px; text-decoration: none; font-weight: 600; display: inline-flex; align-items: center; gap: 8px; white-space: nowrap; transition: all 0.3s ease;"
                     onmouseover="this.style.backgroundColor='#005a2f';"
                     onmouseout="this.style.backgroundColor='#007b40';">
                    <i class="fas fa-arrow-left"></i> Back to Latest News
                  </a>
                </div>
              </div>
            </article>
          </div>

          <!-- Sidebar -->
          <div class="col-12 col-lg-4">
            <div class="post-sidebar">
              

              <!-- Recent Articles -->
              <?php if (!empty($recentPosts)): ?>
              <div class="sidebar-box" style="background: white; border: 1px solid #e0e0e0; padding: 20px; border-radius: 8px; margin-bottom: 25px;">
                <h6 style="color: #007b40; margin: 0 0 18px 0; font-weight: 700; font-size: 14px; text-transform: uppercase; letter-spacing: 0.5px;">
                  <i class="fas fa-clock" style="margin-right: 8px;"></i>Recent Articles
                </h6>
                <ul style="list-style: none; padding: 0; margin: 0; display: flex; flex-direction: column; gap: 12px;">
                  <?php foreach ($recentPosts as $recent): 
                    $recentDate = new DateTime($recent['date_posted']);
                  ?>
                  <li style="border-bottom: 1px solid #f0f0f0; padding-bottom: 12px;">
                    <a href="post-detail.php?id=<?php echo $recent['blog_id']; ?>&link=<?php echo $recent['post_link']; ?>" style="text-decoration: none; color: inherit; transition: all 0.3s ease; display: block; padding: 0; border-radius: 4px;">
                      <div style="display: flex; gap: 12px; align-items: flex-start;">
                        <div style="background: #f0f7f4; padding: 10px 12px; border-radius: 6px; flex-shrink: 0;">
                          <i class="fas fa-newspaper" style="color: #007b40; font-size: 16px;"></i>
                        </div>
                        <div style="flex: 1; min-width: 0;">
                          <h6 style="margin: 0 0 6px 0; font-weight: 600; color: #007b40; font-size: 13px; line-height: 1.4;">
                            <?php echo htmlspecialchars(substr($recent['blog_title'], 0, 40)); ?>
                            <?php if (strlen($recent['blog_title']) > 40) echo '...'; ?>
                          </h6>
                          <span style="font-size: 11px; color: #999;">
                            <i class="fas fa-calendar-alt" style="margin-right: 4px;"></i>
                            <?php echo $con->formatDate($recent['date_posted']); ?>
                          </span>
                        </div>
                      </div>
                    </a>
                  </li>
                  <?php endforeach; ?>
                </ul>
              </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End Post Details Section -->

<?php include_once('layout/footer.php'); ?>
