<?php include_once('layout/header.php'); ?>
    <!--End Page Header-->
    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">Membership Application</h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item active">Membership Application</li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->
    
    <!-- Start Membership Application Form Section -->
    <section class="membership-application mega-section">
      <div class="container">
        <div class="row">
          <div class="col-12 col-lg-9 mx-auto">
            <!-- Progress Bar -->
            <div class="progress-container">
              <div class="progress-bar-wrapper">
                <div class="progress-bar" id="progressBar"></div>
              </div>
              <div class="progress-steps">
                <div class="progress-step active" data-step="1">
                  <div class="step-number">1</div>
                  <div class="step-label">Account Type</div>
                </div>
                <div class="progress-step" data-step="2">
                  <div class="step-number">2</div>
                  <div class="step-label">Personal Info</div>
                </div>
                <div class="progress-step" data-step="3">
                  <div class="step-number">3</div>
                  <div class="step-label">Contact Details</div>
                </div>
                <div class="progress-step" data-step="4">
                  <div class="step-number">4</div>
                  <div class="step-label">Occupation</div>
                </div>
                <div class="progress-step" data-step="5">
                  <div class="step-number">5</div>
                  <div class="step-label">Contributions</div>
                </div>
                <div class="progress-step" data-step="6">
                  <div class="step-number">6</div>
                  <div class="step-label">Next of Kin</div>
                </div>
                <div class="progress-step" data-step="7">
                  <div class="step-number">7</div>
                  <div class="step-label">Referral & Map</div>
                </div>
                <div class="progress-step" data-step="8">
                  <div class="step-number">8</div>
                  <div class="step-label">Declaration</div>
                </div>
              </div>
            </div>

            <!-- Application Form -->
            <form id="membershipApplicationForm" class="application-form" enctype="multipart/form-data">
              
              <!-- Step 1: Account Type & Branch -->
              <div class="form-step active" data-step="1">
                <div class="step-header">
                  <h2>Account Type Selection</h2>
                  <p>Choose your membership account type</p>
                </div>

                <div class="form-section">
                  <div class="form-row">
                    <div class="form-group full-width">
                      <label class="form-label">Type of Account <span class="text-danger">*</span></label>
                      <div class="account-type-options">
                        <label class="radio-option">
                          <input type="radio" name="account_type" value="member_ordinary" required>
                          <span>Member Ordinary</span>
                        </label>
                        <label class="radio-option">
                          <input type="radio" name="account_type" value="mawa_langa_savings">
                          <span>Mawa Langa Savings</span>
                        </label>
                        <label class="radio-option">
                          <input type="radio" name="account_type" value="youth_savings">
                          <span>Youth Savings</span>
                        </label>
                      </div>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="branch" class="form-label">Branch <span class="text-danger">*</span></label>
                      <input type="text" id="branch" name="branch" class="form-control" placeholder="Enter your branch" required>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Step 2: Personal Information -->
              <div class="form-step" data-step="2">
                <div class="step-header">
                  <h2>Personal Information</h2>
                  <p>Please provide your personal details</p>
                </div>

                <div class="form-section">
                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="fullName" class="form-label">Full Name (as per National ID) <span class="text-danger">*</span></label>
                      <input type="text" id="fullName" name="full_name" class="form-control" placeholder="Enter your full name" required>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="idType" class="form-label">Type of ID <span class="text-danger">*</span></label>
                      <select id="idType" name="id_type" class="form-control" required>
                        <option value="">Select ID Type</option>
                        <option value="national_id">National ID</option>
                        <option value="passport">Passport</option>
                        <option value="drivers_license">Driver's License</option>
                        <option value="other">Other</option>
                      </select>
                    </div>

                    <div class="form-group">
                      <label for="idNumber" class="form-label">ID Number <span class="text-danger">*</span></label>
                      <input type="text" id="idNumber" name="id_number" class="form-control" placeholder="Enter ID number" required>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="dateOfBirth" class="form-label">Date of Birth</label>
                      <input type="date" id="dateOfBirth" name="date_of_birth" class="form-control">
                    </div>

                    <div class="form-group">
                      <label class="form-label">Gender <span class="text-danger">*</span></label>
                      <div class="radio-inline">
                        <label class="radio-option-inline">
                          <input type="radio" name="gender" value="male" required>
                          <span>Male</span>
                        </label>
                        <label class="radio-option-inline">
                          <input type="radio" name="gender" value="female">
                          <span>Female</span>
                        </label>
                        <label class="radio-option-inline">
                          <input type="radio" name="gender" value="other">
                          <span>Other</span>
                        </label>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Step 3: Contact Details -->
              <div class="form-step" data-step="3">
                <div class="step-header">
                  <h2>Contact Information</h2>
                  <p>Provide your contact details</p>
                </div>

                <div class="form-section">
                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="contactAddress" class="form-label">Contact Address</label>
                      <input type="text" id="contactAddress" name="contact_address" class="form-control" placeholder="Enter your contact address">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="permanentAddress" class="form-label">Permanent Address</label>
                      <input type="text" id="permanentAddress" name="permanent_address" class="form-control" placeholder="Enter your permanent address">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="village" class="form-label">Village</label>
                      <input type="text" id="village" name="village" class="form-control" placeholder="Enter village">
                    </div>

                    <div class="form-group">
                      <label for="town" class="form-label">Town</label>
                      <input type="text" id="town" name="town" class="form-control" placeholder="Enter town">
                    </div>

                    <div class="form-group">
                      <label for="district" class="form-label">District</label>
                      <input type="text" id="district" name="district" class="form-control" placeholder="Enter district">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="phoneNumber" class="form-label">Primary Mobile Number <span class="text-danger">*</span></label>
                      <input type="tel" id="phoneNumber" name="phone_number" class="form-control" placeholder="Enter mobile number" required>
                    </div>

                    <div class="form-group">
                      <label for="email" class="form-label">Email Address</label>
                      <input type="email" id="email" name="email" class="form-control" placeholder="Enter email address">
                    </div>
                  </div>

                  <!-- Marital Status Section -->
                  <h4 style="margin-top: 25px; margin-bottom: 15px; color: #007b40; font-weight: 600;">Marital Status</h4>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label class="form-label">Marital Status <span class="text-danger">*</span></label>
                      <div class="radio-inline">
                        <label class="radio-option-inline">
                          <input type="radio" name="marital_status" value="single" required>
                          <span>Single</span>
                        </label>
                        <label class="radio-option-inline">
                          <input type="radio" name="marital_status" value="married">
                          <span>Married</span>
                        </label>
                        <label class="radio-option-inline">
                          <input type="radio" name="marital_status" value="divorced">
                          <span>Divorced</span>
                        </label>
                        <label class="radio-option-inline">
                          <input type="radio" name="marital_status" value="widowed">
                          <span>Widowed</span>
                        </label>
                        <label class="radio-option-inline">
                          <input type="radio" name="marital_status" value="other">
                          <span>Other</span>
                        </label>
                      </div>
                    </div>
                  </div>

                  <div class="form-row" id="spouseSection" style="display: none;">
                    <div class="form-group">
                      <label for="spouseName" class="form-label">Name of Spouse</label>
                      <input type="text" id="spouseName" name="spouse_name" class="form-control" placeholder="Enter spouse name">
                    </div>

                    <div class="form-group">
                      <label for="spouseIdType" class="form-label">Spouse ID Type</label>
                      <select id="spouseIdType" name="spouse_id_type" class="form-control">
                        <option value="">Select ID Type</option>
                        <option value="national_id">National ID</option>
                        <option value="passport">Passport</option>
                        <option value="drivers_license">Driver's License</option>
                      </select>
                    </div>
                  </div>

                  <div class="form-row" id="spouseSection2" style="display: none;">
                    <div class="form-group">
                      <label for="spouseIdNumber" class="form-label">Spouse ID Number</label>
                      <input type="text" id="spouseIdNumber" name="spouse_id_number" class="form-control" placeholder="Enter spouse ID number">
                    </div>

                    <div class="form-group">
                      <label for="spousePhone" class="form-label">Spouse Phone Number</label>
                      <input type="tel" id="spousePhone" name="spouse_phone" class="form-control" placeholder="Enter spouse phone">
                    </div>

                    <div class="form-group">
                      <label for="spouseEmail" class="form-label">Spouse Email</label>
                      <input type="email" id="spouseEmail" name="spouse_email" class="form-control" placeholder="Enter spouse email">
                    </div>
                  </div>
                </div>
              </div>

              <!-- Step 4: Occupation Details -->
              <div class="form-step" data-step="4">
                <div class="step-header">
                  <h2>Occupation Details</h2>
                  <p>Provide your employment/occupation information</p>
                </div>

                <div class="form-section">
                  <div class="form-row">
                    <div class="form-group full-width">
                      <label class="form-label">Occupation Type <span class="text-danger">*</span></label>
                      <div class="radio-inline">
                        <label class="radio-option-inline">
                          <input type="radio" name="occupation_type" value="salaried" required>
                          <span>Salaried</span>
                        </label>
                        <label class="radio-option-inline">
                          <input type="radio" name="occupation_type" value="business">
                          <span>Business</span>
                        </label>
                        <label class="radio-option-inline">
                          <input type="radio" name="occupation_type" value="student">
                          <span>Student</span>
                        </label>
                        <label class="radio-option-inline">
                          <input type="radio" name="occupation_type" value="other">
                          <span>Other</span>
                        </label>
                      </div>
                    </div>
                  </div>

                  <div class="form-row" id="occupationOtherSection" style="display: none;">
                    <div class="form-group full-width">
                      <label for="occupationOther" class="form-label">Specify Other Occupation</label>
                      <input type="text" id="occupationOther" name="occupation_other" class="form-control" placeholder="Specify your occupation">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="institutionName" class="form-label">Name of Institution/Business</label>
                      <input type="text" id="institutionName" name="institution_name" class="form-control" placeholder="Enter institution or business name">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="institutionPostalAddress" class="form-label">Postal Address</label>
                      <input type="text" id="institutionPostalAddress" name="institution_postal_address" class="form-control" placeholder="Enter postal address">
                    </div>

                    <div class="form-group">
                      <label for="institutionPhone" class="form-label">Phone Number</label>
                      <input type="tel" id="institutionPhone" name="institution_phone" class="form-control" placeholder="Enter phone number">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="professionJobTitle" class="form-label">Profession/Job Title</label>
                      <input type="text" id="professionJobTitle" name="profession_job_title" class="form-control" placeholder="Enter profession or job title">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="mailingAddress" class="form-label">Mailing Address</label>
                      <input type="text" id="mailingAddress" name="mailing_address" class="form-control" placeholder="Enter mailing address">
                    </div>
                  </div>
                </div>
              </div>

              <!-- Step 5: Monthly Contributions -->
              <div class="form-step" data-step="5">
                <div class="step-header">
                  <h2>Monthly Contributions</h2>
                  <p>Specify your monthly savings and contributions</p>
                </div>

                <div class="form-section">
                  <div class="contribution-table">
                    <table>
                      <thead>
                        <tr>
                          <th>Contribution Type</th>
                          <th>Amount (KES)</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                          <td><label for="monthlySavings">Savings</label></td>
                          <td><input type="number" id="monthlySavings" name="monthly_savings" class="form-control" placeholder="0.00" step="0.01" min="0"></td>
                        </tr>
                        <tr>
                          <td><label for="monthlyShares">Shares</label></td>
                          <td><input type="number" id="monthlyShares" name="monthly_shares" class="form-control" placeholder="0.00" step="0.01" min="0"></td>
                        </tr>
                        <tr>
                          <td><label for="monthlyFixedDeposit">Fixed Deposit</label></td>
                          <td><input type="number" id="monthlyFixedDeposit" name="monthly_fixed_deposit" class="form-control" placeholder="0.00" step="0.01" min="0"></td>
                        </tr>
                        <tr>
                          <td><label for="kangachepeFuneralCover">Kangachepe Funeral Cover</label></td>
                          <td><input type="number" id="kangachepeFuneralCover" name="kangachepe_funeral_cover" class="form-control" placeholder="0.00" step="0.01" min="0"></td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>

              <!-- Step 6: Next of Kin -->
              <div class="form-step" data-step="6">
                <div class="step-header">
                  <h2>Next of Kin & Beneficiaries</h2>
                  <p>Provide next of kin and nominated beneficiaries information</p>
                </div>

                <div class="form-section">
                  <h4 style="margin-bottom: 15px; color: #007b40; font-weight: 600;">Next of Kin (In case of emergencies)</h4>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="nextOfKinName" class="form-label">Name</label>
                      <input type="text" id="nextOfKinName" name="next_of_kin_name" class="form-control" placeholder="Enter name">
                    </div>

                    <div class="form-group">
                      <label for="nextOfKinDob" class="form-label">Date of Birth</label>
                      <input type="date" id="nextOfKinDob" name="next_of_kin_dob" class="form-control">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="nextOfKinPhone" class="form-label">Phone Numbers</label>
                      <input type="tel" id="nextOfKinPhone" name="next_of_kin_phone" class="form-control" placeholder="Enter phone number">
                    </div>

                    <div class="form-group">
                      <label for="nextOfKinEmail" class="form-label">Email Address</label>
                      <input type="email" id="nextOfKinEmail" name="next_of_kin_email" class="form-control" placeholder="Enter email address">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="nextOfKinAddress" class="form-label">Contact Address</label>
                      <input type="text" id="nextOfKinAddress" name="next_of_kin_address" class="form-control" placeholder="Enter contact address">
                    </div>

                    <div class="form-group">
                      <label for="nextOfKinRelationship" class="form-label">Relationship</label>
                      <input type="text" id="nextOfKinRelationship" name="next_of_kin_relationship" class="form-control" placeholder="E.g. Brother, Sister, Spouse">
                    </div>
                  </div>

                  <h4 style="margin-top: 25px; margin-bottom: 15px; color: #007b40; font-weight: 600;">Nominated Kins (If there is more than one, allocate the percentage)</h4>

                  <div id="nominatedKinsContainer">
                    <div class="nominated-kin-row">
                      <div class="form-row">
                        <div class="form-group">
                          <label class="form-label">Full Name</label>
                          <input type="text" class="nominated-kin-name form-control" placeholder="Enter name">
                        </div>

                        <div class="form-group">
                          <label class="form-label">Date of Birth</label>
                          <input type="date" class="nominated-kin-dob form-control">
                        </div>

                        <div class="form-group">
                          <label class="form-label">ID Number</label>
                          <input type="text" class="nominated-kin-id form-control" placeholder="Enter ID number">
                        </div>
                      </div>

                      <div class="form-row">
                        <div class="form-group">
                          <label class="form-label">Relationship</label>
                          <input type="text" class="nominated-kin-relationship form-control" placeholder="Enter relationship">
                        </div>

                        <div class="form-group">
                          <label class="form-label">Percentage Allocated (%)</label>
                          <input type="number" class="nominated-kin-percentage form-control" placeholder="0" min="0" max="100" step="0.01">
                        </div>

                        <div class="form-group" style="display: flex; align-items: flex-end;">
                          <button type="button" class="btn btn-sm btn-danger remove-nominated-kin" style="display: none;">Remove</button>
                        </div>
                      </div>
                    </div>
                  </div>

                  <button type="button" class="btn btn-sm btn-primary" id="addNominatedKinBtn" style="margin-top: 10px;">+ Add Another Nominated Kin</button>
                </div>
              </div>

              <!-- Step 7: Referral Source & Sketch Map -->
              <div class="form-step" data-step="7">
                <div class="step-header">
                  <h2>Referral Source & Location</h2>
                  <p>How did you hear about us and your location details</p>
                </div>

                <div class="form-section">
                  <h4 style="margin-bottom: 15px; color: #007b40; font-weight: 600;">Who Convinced You to Join Sunbird SACCO?</h4>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <div class="checkbox-inline">
                        <label class="checkbox-option-inline">
                          <input type="checkbox" name="referral_source" value="sms_advert">
                          <span>SMS Advert</span>
                        </label>
                        <label class="checkbox-option-inline">
                          <input type="checkbox" name="referral_source" value="social_media">
                          <span>Social Media</span>
                        </label>
                        <label class="checkbox-option-inline">
                          <input type="checkbox" name="referral_source" value="phone_call">
                          <span>Phone Call</span>
                        </label>
                        <label class="checkbox-option-inline">
                          <input type="checkbox" name="referral_source" value="self_registration">
                          <span>Self-registration</span>
                        </label>
                        <label class="checkbox-option-inline">
                          <input type="checkbox" name="referral_source" value="tv_radio">
                          <span>TV/Radio Advert</span>
                        </label>
                        <label class="checkbox-option-inline">
                          <input type="checkbox" name="referral_source" value="staff">
                          <span>Sunbird Sales Staff</span>
                        </label>
                        <label class="checkbox-option-inline">
                          <input type="checkbox" name="referral_source" value="other">
                          <span>Other</span>
                        </label>
                      </div>
                    </div>
                  </div>

                  <div class="form-row" id="referralOtherSection" style="display: none;">
                    <div class="form-group full-width">
                      <label for="referralOther" class="form-label">Specify Other</label>
                      <input type="text" id="referralOther" name="referral_other" class="form-control" placeholder="Specify how you heard about us">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="referrerName" class="form-label">Sunbird SACCO Staff Member (if applicable)</label>
                      <input type="text" id="referrerName" name="referrer_name" class="form-control" placeholder="Enter staff member name">
                    </div>
                  </div>

                  <h4 style="margin-top: 25px; margin-bottom: 15px; color: #007b40; font-weight: 600;">Sketch Map (Current location to your home, business area, or school)</h4>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="sketchMapDescription" class="form-label">Location Description</label>
                      <textarea id="sketchMapDescription" name="sketch_map_description" class="form-control" rows="4" placeholder="Describe your location clearly"></textarea>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="sketchMapFile" class="form-label">Upload Sketch Map Image</label>
                      <input type="file" id="sketchMapFile" name="sketch_map_file" class="form-control" accept="image/*">
                      <small class="form-text text-muted">Accepted formats: JPG, PNG, GIF (Max 5MB)</small>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Step 8: Declaration & Submission -->
              <div class="form-step" data-step="8">
                <div class="step-header">
                  <h2>Declaration & Agreement</h2>
                  <p>Review and accept the membership terms</p>
                </div>

                <div class="form-section">
                  <div class="declaration-box">
                    <h4>Declaration of Truth</h4>
                    <p>I hereby declare that the information provided in this membership application form is true, accurate, and complete to the best of my knowledge. I understand that providing false or misleading information may result in the rejection of my application and possible legal consequences. I agree to abide by the constitution, by-laws, and regulations of Sunbird SACCO as amended from time to time.</p>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label class="checkbox-option">
                        <input type="checkbox" name="agreement" id="agreement" required>
                        <span>I agree to the terms and conditions of membership</span>
                      </label>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label class="checkbox-option">
                        <input type="checkbox" name="data_consent" id="dataConsent" required>
                        <span>I consent to the processing of my personal data as per the privacy policy</span>
                      </label>
                    </div>
                  </div>

                  <hr style="margin: 30px 0; border: none; border-top: 2px solid #f0f0f0;">

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="applicantName" class="form-label">Applicant Name (Printed)</label>
                      <input type="text" id="applicantName" name="applicant_name" class="form-control" placeholder="Enter your full name">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="applicantSignatureDate" class="form-label">Date</label>
                      <input type="date" id="applicantSignatureDate" name="applicant_signature_date" class="form-control">
                    </div>

                    <div class="form-group">
                      <label for="applicantSignature" class="form-label">Signature</label>
                      <input type="text" id="applicantSignature" name="applicant_signature" class="form-control" placeholder="(Signature)">
                    </div>
                  </div>
                </div>
              </div>

              <!-- Form Navigation Buttons -->
              <div class="form-navigation">
                <button type="button" class="btn btn-secondary" id="prevBtn" style="display: none;">
                  <i class="fas fa-arrow-left"></i> Previous
                </button>
                <button type="button" class="btn btn-primary" id="nextBtn">
                  Next <i class="fas fa-arrow-right"></i>
                </button>
                <button type="submit" class="btn btn-success" id="submitBtn" style="display: none;">
                  <i class="fas fa-check"></i> Submit Application
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </section>
    <!-- End Membership Application Form Section -->
    
    <?php include_once('layout/footer.php'); ?>
    
    <!-- Stylesheets -->
    <link rel="stylesheet" href="css/membership-application.css">
    
    <!-- Scripts -->
    <script src="js/membership-application.js"></script>