<?php include_once('layout/header.php'); ?>
<?php
// Fetch loans from database
$loans = $con->getRows('loan_types', array('order_by' => 'id ASC'));
$totalLoans = $loans ? count($loans) : 0;
?>
    <!--End Page Header-->
    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">Our Loan Products</h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item active">Our Loans</li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->

    <!-- Start Loans Grid Section -->
    <section class="loans-section mega-section" id="loans-main" style="padding: 80px 0; background: #f9f9f9;">
      <div class="container">
        <!-- Section Header -->
        <div class="section-heading center-heading" style="margin-bottom: 60px;">
          <h2 class="section-title wow fadeInUp" data-wow-delay=".2s" style="font-size: 42px; color: #333; margin-bottom: 20px;">Explore Our Flexible Loan Options<span class="title-design-element "></span></h2>
          <p class="section-description wow fadeInUp" data-wow-delay=".4s" style="font-size: 16px; color: #666; max-width: 700px; margin: 0 auto; line-height: 1.8;">We offer a variety of loan products designed to help you achieve your financial goals. From personal loans to business financing, find the perfect solution for your needs.</p>
          <div class="line line-on-center wow fadeIn" data-wow-delay=".7s" style="margin-top: 30px;"></div>
        </div>

        <!-- Stats Row -->
        <div class="row text-center mb-5">
          <div class="col-12 col-md-4 mb-3 mb-md-0">
            <div class="stat-box wow fadeInUp" data-wow-delay="0.2s">
              <h3 style="font-size: 36px; color: #007b40; font-weight: 700; margin-bottom: 5px;"><?php echo $totalLoans; ?></h3>
              <p style="font-size: 14px; color: #666;">Loan Products</p>
            </div>
          </div>
          <div class="col-12 col-md-4 mb-3 mb-md-0">
            <div class="stat-box wow fadeInUp" data-wow-delay="0.3s">
              <h3 style="font-size: 36px; color: #007b40; font-weight: 700; margin-bottom: 5px;">Flexible</h3>
              <p style="font-size: 14px; color: #666;">Terms & Repayment</p>
            </div>
          </div>
          <div class="col-12 col-md-4">
            <div class="stat-box wow fadeInUp" data-wow-delay="0.4s">
              <h3 style="font-size: 36px; color: #007b40; font-weight: 700; margin-bottom: 5px;">Competitive</h3>
              <p style="font-size: 14px; color: #666;">Interest Rates</p>
            </div>
          </div>
        </div>

        <!-- Loans Grid -->
        <div class="row mt-5">
          <?php
          if ($loans) {
            foreach ($loans as $index => $loan) {
              $delay = (0.15 + ($index * 0.08)) > 0.7 ? 0.7 : (0.15 + ($index * 0.08));
              $loan_id = isset($loan['id']) ? $loan['id'] : 0;
              ?>
          <div class="col-12 col-md-6 col-lg-4 mb-4">
            <div class="loan-card-modern wow fadeInUp" data-wow-delay="<?php echo $delay; ?>s" style="
              background: white;
              border-radius: 12px;
              padding: 35px;
              height: 100%;
              box-shadow: 0 2px 10px rgba(0,0,0,0.08);
              transition: all 0.3s ease;
              position: relative;
              overflow: hidden;
              border-top: 4px solid #007b40;
            " onmouseover="this.style.boxShadow='0 10px 30px rgba(0,123,64,0.15)'; this.style.transform='translateY(-5px)';" onmouseout="this.style.boxShadow='0 2px 10px rgba(0,0,0,0.08)'; this.style.transform='translateY(0)';">
              
              <!-- Loan Icon Background -->
              <div style="
                position: absolute;
                top: -40px;
                right: -40px;
                width: 150px;
                height: 150px;
                background: rgba(0,123,64,0.05);
                border-radius: 50%;
              "></div>

              <!-- Loan Name -->
              <h3 style="
                font-size: 22px;
                font-weight: 700;
                color: #007b40;
                margin-bottom: 15px;
                position: relative;
                z-index: 2;
              "><?php echo htmlspecialchars($loan['loan_name']); ?></h3>

              <!-- Loan Description -->
              <p style="
                font-size: 14px;
                line-height: 1.7;
                color: #666;
                margin-bottom: 25px;
                position: relative;
                z-index: 2;
              "><?php 
                $description = $loan['loan_description'];
                echo strlen($description) > 150 ? substr($description, 0, 150) . '...' : $description;
              ?></p>

              <!-- Fee Summary -->
              <div style="
                background: #f5f5f5;
                border-radius: 8px;
                padding: 20px;
                margin-bottom: 25px;
                position: relative;
                z-index: 2;
              ">
                <div class="fee-row" style="display: flex; justify-content: space-between; margin-bottom: 12px; padding-bottom: 12px; border-bottom: 1px solid #e0e0e0;">
                  <span style="font-size: 13px; color: #666; font-weight: 500;">Interest Rate:</span>
                  <span style="font-size: 14px; font-weight: 700; color: #007b40;"><?php echo htmlspecialchars($loan['interest_rate_monthly']); ?>% /month</span>
                </div>
                <div class="fee-row" style="display: flex; justify-content: space-between; margin-bottom: 12px; padding-bottom: 12px; border-bottom: 1px solid #e0e0e0;">
                  <span style="font-size: 13px; color: #666; font-weight: 500;">Processing Fee:</span>
                  <span style="font-size: 14px; font-weight: 700; color: #333;"><?php echo htmlspecialchars($loan['processing_fee']); ?>%</span>
                </div>
                <div class="fee-row" style="display: flex; justify-content: space-between;">
                  <span style="font-size: 13px; color: #666; font-weight: 500;">Insurance Fee:</span>
                  <span style="font-size: 14px; font-weight: 700; color: #333;"><?php echo htmlspecialchars($loan['insurance_fee_yearly']); ?>% /year</span>
                </div>
              </div>

              <!-- Action Button -->
              <a href="loan-detail.php?id=<?php echo $loan_id; ?>" style="
                display: block;
                text-align: center;
                background: #007b40;
                color: white;
                padding: 12px 20px;
                border-radius: 50px;
                font-weight: 600;
                text-decoration: none;
                transition: all 0.3s ease;
                font-size: 14px;
                position: relative;
                z-index: 2;
              " onmouseover="this.style.background='#005a2e';" onmouseout="this.style.background='#007b40';">
                View Details <i class="fas fa-arrow-right" style="margin-left: 8px;"></i>
              </a>
            </div>
          </div>
              <?php
            }
          } else {
            ?>
          <div class="col-12 text-center">
            <p style="font-size: 18px; color: #666; padding: 40px 0;">No loan products available at the moment.</p>
          </div>
            <?php
          }
          ?>
        </div>
      </div>
    </section>
    <!-- End Loans Grid Section -->

    <!-- Start CTA Section - Apply for Loan -->
    <section class="cta-section" style="
      background: linear-gradient(135deg, #007b40 0%, #005a2e 100%);
      padding: 80px 0;
      position: relative;
      overflow: hidden;
    " id="cta-loan">
      <div class="overlay-pattern-image-bg" style="opacity: 0.1;"></div>
      <div class="container" style="position: relative; z-index: 2;">
        <div class="row align-items-center">
          <div class="col-12 col-lg-8">
            <h2 style="
              font-size: 36px;
              color: white;
              margin-bottom: 15px;
              font-weight: 700;
            " class="wow fadeInLeft" data-wow-delay="0.2s">Ready to apply for a loan?</h2>
            <p style="
              font-size: 16px;
              color: rgba(255,255,255,0.9);
              margin-bottom: 0;
              line-height: 1.7;
            " class="wow fadeInLeft" data-wow-delay="0.4s;">Our application process is simple and straightforward. Apply online today and get approved quickly with competitive interest rates.</p>
          </div>
          <div class="col-12 col-lg-4 text-lg-end mt-4 mt-lg-0">
            <a href="loan_application.php" class="btn-solid" style="
              background: white;
              color: #007b40;
              padding: 15px 40px;
              border-radius: 50px;
              font-weight: 600;
              text-decoration: none;
              display: inline-block;
              transition: all 0.3s ease;
              font-size: 16px;
            " onmouseover="this.style.transform='scale(1.05)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.2)';" onmouseout="this.style.transform='scale(1)'; this.style.boxShadow='none';" class="wow fadeInRight" data-wow-delay="0.2s">Apply Now</a>
          </div>
        </div>
      </div>
    </section>
    <!-- End CTA Section -->

    <?php include_once('layout/footer.php'); ?>