<?php include_once('layout/header.php'); ?>
    <!--End Page Header-->
    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">Loan Calculator</h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item active">Loan Calculator</li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->
    <!-- Start Loan Calculator Section -->
    <section class="loan-calculator mega-section">
      <div class="container">
        <div class="row">
          <div class="col-12 col-lg-9 mx-auto">
            <div class="calculator-wrapper">
              <div class="calculator-card">
                <div class="card-header">
                  <div class="header-content">
                    <h2 class="calculator-title">
                      <i class="fas fa-calculator"></i> Calculate Your Loan
                    </h2>
                    <p class="calculator-subtitle">Get an instant estimate of your loan repayment plan</p>
                  </div>
                </div>
                
                <form id="loanCalculatorForm" class="loan-form">
                  <!-- Loan Type Section -->
                  <div class="form-section">
                    <div class="form-group">
                      <label for="loanType" class="form-label">
                        <i class="fas fa-hand-holding-usd"></i> 
                        <span>Loan Type</span>
                        <span class="required">*</span>
                      </label>
                      <select id="loanType" class="form-control form-select" required>
                        <option value="">-- Select Loan Type --</option>
                      </select>
                      <small class="form-hint">Choose the loan product that best suits your needs</small>
                    </div>
                  </div>

                  <!-- Amount and Period Section -->
                  <div class="form-section">
                    <div class="form-row">
                      <div class="form-group">
                        <label for="loanAmount" class="form-label">
                          <i class="fas fa-money-bill-wave"></i> 
                          <span>Loan Amount</span>
                          <span class="required">*</span>
                        </label>
                        <div class="input-group">
                          <span class="input-group-text currency-badge">MWK</span>
                          <input type="number" id="loanAmount" class="form-control" placeholder="0.00" min="1000" step="100" required>
                        </div>
                        <small class="form-hint">Minimum: MWK 1,000</small>
                      </div>

                      <div class="form-group">
                        <label for="loanTerm" class="form-label">
                          <i class="fas fa-calendar-days"></i> 
                          <span>Repayment Period</span>
                          <span class="required">*</span>
                        </label>
                        <div class="input-group">
                          <input type="number" id="loanTerm" class="form-control" placeholder="12" min="1" max="60" value="12" required>
                          <span class="input-group-text period-badge">months</span>
                        </div>
                        <small class="form-hint">1 - 60 months</small>
                      </div>
                    </div>
                  </div>

                  <!-- Button Section -->
                  <div class="form-section button-section">
                    <button type="button" class="btn btn-calculate" id="calculateBtn">
                      <i class="fas fa-calculator"></i> 
                      <span>Calculate Loan Details</span>
                    </button>
                  </div>
                </form>
              </div>

            <!-- Loan Breakdown Section -->
            <div id="breakdownSection" class="breakdown-section" style="display: none;">
              <h2 class="breakdown-title"><i class="fas fa-chart-pie"></i> Loan Breakdown</h2>
              
              <div class="breakdown-card">
                <div class="card-header">
                  <h3 class="card-title">Disbursement Details</h3>
                </div>
                <div class="card-body">
                  <div class="breakdown-item">
                    <div class="item-info">
                      <span class="item-label">Requested Amount:</span>
                      <span class="item-desc">Your requested loan amount</span>
                    </div>
                    <span class="item-value" id="requestedAmount">MWK 0.00</span>
                  </div>
                  <div class="breakdown-item">
                    <div class="item-info">
                      <span class="item-label">Processing Fee <span class="fee-rate" id="processingRate">(2.5%)</span>:</span>
                      <span class="item-desc">One-time deduction from requested amount</span>
                    </div>
                    <span class="item-value fee-negative" id="processingFee">- MWK 0.00</span>
                  </div>
                  <div class="breakdown-item highlight">
                    <div class="item-info">
                      <span class="item-label"><strong>Actual Disbursement:</strong></span>
                      <span class="item-desc">Amount you will receive after fees</span>
                    </div>
                    <span class="item-value amount-positive" id="actualDisbursement"><strong>MWK 0.00</strong></span>
                  </div>
                </div>
              </div>

              <div class="breakdown-card">
                <div class="card-header">
                  <h3 class="card-title">Monthly Repayment Details</h3>
                </div>
                <div class="card-body">
                  <div class="breakdown-item">
                    <div class="item-info">
                      <span class="item-label">Loan Period:</span>
                      <span class="item-desc">Your repayment duration</span>
                    </div>
                    <span class="item-value" id="totalMonths">12 Months</span>
                  </div>
                  <div class="breakdown-item">
                    <div class="item-info">
                      <span class="item-label">Monthly Interest Rate <span class="fee-rate" id="monthlyRatePercent">(3.5%)</span>:</span>
                      <span class="item-desc">Interest charged on disbursed amount</span>
                    </div>
                    <span class="item-value" id="monthlyRate">0.00%</span>
                  </div>
                  <div class="breakdown-item">
                    <div class="item-info">
                      <span class="item-label">Monthly Principal:</span>
                      <span class="item-desc">Fixed principal repayment per month</span>
                    </div>
                    <span class="item-value" id="monthlyPrincipal">MWK 0.00</span>
                  </div>
                  <div class="breakdown-item">
                    <div class="item-info">
                      <span class="item-label">Interest on Principal:</span>
                      <span class="item-desc">Monthly interest charge</span>
                    </div>
                    <span class="item-value" id="interestOnPrincipal">MWK 0.00</span>
                  </div>
                  <div class="breakdown-item">
                    <div class="item-info">
                      <span class="item-label">Insurance Fee <span class="fee-rate">(1% p.a.)</span>:</span>
                      <span class="item-desc">Monthly insurance allocation</span>
                    </div>
                    <span class="item-value" id="monthlyInsurance">MWK 0.00</span>
                  </div>
                  <div class="breakdown-item highlight">
                    <div class="item-info">
                      <span class="item-label"><strong>Total Monthly Payment:</strong></span>
                      <span class="item-desc">Total you pay each month</span>
                    </div>
                    <span class="item-value amount-primary" id="monthlyPayment"><strong>MWK 0.00</strong></span>
                  </div>
                </div>
              </div>

              <div class="breakdown-card">
                <div class="card-header">
                  <h3 class="card-title">Total Cost Summary</h3>
                </div>
                <div class="card-body">
                  <div class="breakdown-item">
                    <div class="item-info">
                      <span class="item-label">Principal Amount:</span>
                      <span class="item-desc">Amount you borrowed (after fee deduction)</span>
                    </div>
                    <span class="item-value" id="totalPrincipal">MWK 0.00</span>
                  </div>
                  <div class="breakdown-item">
                    <div class="item-info">
                      <span class="item-label">Total Interest:</span>
                      <span class="item-desc">All interest over the loan period</span>
                    </div>
                    <span class="item-value" id="totalInterest">MWK 0.00</span>
                  </div>
                  <div class="breakdown-item">
                    <div class="item-info">
                      <span class="item-label">Total Insurance:</span>
                      <span class="item-desc">All insurance fees over the loan period</span>
                    </div>
                    <span class="item-value" id="totalInsuranceCost">MWK 0.00</span>
                  </div>
                  <div class="breakdown-item highlight">
                    <div class="item-info">
                      <span class="item-label"><strong>Total to be Repaid:</strong></span>
                      <span class="item-desc">Principal + Interest + Insurance</span>
                    </div>
                    <span class="item-value amount-danger" id="totalRepayment"><strong>MWK 0.00</strong></span>
                  </div>
                  <div class="breakdown-item highlight">
                    <div class="item-info">
                      <span class="item-label"><strong>Total Cost of Loan:</strong></span>
                      <span class="item-desc">Interest + Insurance (What you pay extra)</span>
                    </div>
                    <span class="item-value amount-warning" id="totalCost"><strong>MWK 0.00</strong></span>
                  </div>
                </div>
              </div>

              <button type="button" class="btn btn-secondary btn-block btn-lg" id="resetBtn">
                <i class="fas fa-redo icon"></i> Calculate Another Loan
              </button>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End Loan Calculator Section -->
   <?php include_once('layout/footer.php'); ?>
   
   <!-- Include jQuery and Calculator Script -->
   <link rel="stylesheet" href="css/loan-calculator.css">
   <script src="js/loan-calculator.js"></script>