<?php include_once('layout/header.php'); ?>
<?php
// Get loan ID from URL
$loan_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch specific loan details
$loan = $con->getRows('loan_types', array(
    'where' => array('id' => $loan_id),
    'return_type' => 'single'
));

// If loan not found, redirect to loans page
if (!$loan) {
    header("Location: loans.php");
    exit;
}
?>

    <!--End Page Header-->
    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s"><?php echo htmlspecialchars($loan['loan_name']); ?></h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="loans.php">Our Loans</a></li>
                  <li class="breadcrumb-item active"><?php echo htmlspecialchars($loan['loan_name']); ?></li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->

    <!-- Start Loan Detail Section -->
    <section class="loan-detail-section mega-section" style="padding: 80px 0; background: #f9f9f9;">
      <div class="container">
        <div class="row">
          <!-- Main Content -->
          <div class="col-12 col-lg-8">
            <!-- Loan Overview -->
            <div class="loan-overview-card" style="
              background: white;
              border-radius: 12px;
              padding: 40px;
              margin-bottom: 40px;
              box-shadow: 0 2px 10px rgba(0,0,0,0.08);
              wow fadeInUp
            " data-wow-delay="0.2s">
              <h2 style="
                font-size: 32px;
                color: #007b40;
                margin-bottom: 20px;
                font-weight: 700;
              "><?php echo htmlspecialchars($loan['loan_name']); ?></h2>

              <div class="description-content" style="
                font-size: 15px;
                line-height: 1.8;
                color: #555;
                margin-bottom: 30px;
              ">
                <p><?php echo nl2br($loan['loan_description']); ?></p>
              </div>

              <!-- Divider -->
              <div style="height: 2px; background: linear-gradient(to right, #007b40, transparent); margin-bottom: 30px;"></div>

              <h3 style="
                font-size: 22px;
                color: #333;
                margin-bottom: 25px;
                font-weight: 700;
              ">Loan Terms & Conditions</h3>

              <!-- Features List -->
              <ul style="list-style: none; padding: 0;">
                <li style="
                  padding: 12px 0;
                  padding-left: 30px;
                  border-bottom: 1px solid #f0f0f0;
                  position: relative;
                " class="wow fadeInLeft" data-wow-delay="0.3s">
                  <i class="fas fa-check" style="
                    position: absolute;
                    left: 0;
                    color: #007b40;
                    font-weight: bold;
                  "></i>
                  <strong style="color: #333;">Competitive Interest Rate:</strong> <span style="color: #666;"><?php echo htmlspecialchars($loan['interest_rate_monthly']); ?>% per month</span>
                </li>
                <li style="
                  padding: 12px 0;
                  padding-left: 30px;
                  border-bottom: 1px solid #f0f0f0;
                  position: relative;
                " class="wow fadeInLeft" data-wow-delay="0.4s">
                  <i class="fas fa-check" style="
                    position: absolute;
                    left: 0;
                    color: #007b40;
                    font-weight: bold;
                  "></i>
                  <strong style="color: #333;">Processing Fee:</strong> <span style="color: #666;"><?php echo htmlspecialchars($loan['processing_fee']); ?>% (one-time)</span>
                </li>
                <li style="
                  padding: 12px 0;
                  padding-left: 30px;
                  border-bottom: 1px solid #f0f0f0;
                  position: relative;
                " class="wow fadeInLeft" data-wow-delay="0.5s">
                  <i class="fas fa-check" style="
                    position: absolute;
                    left: 0;
                    color: #007b40;
                    font-weight: bold;
                  "></i>
                  <strong style="color: #333;">Insurance Fee:</strong> <span style="color: #666;"><?php echo htmlspecialchars($loan['insurance_fee_yearly']); ?>% per year</span>
                </li>
                <li style="
                  padding: 12px 0;
                  padding-left: 30px;
                  position: relative;
                " class="wow fadeInLeft" data-wow-delay="0.6s">
                  <i class="fas fa-check" style="
                    position: absolute;
                    left: 0;
                    color: #007b40;
                    font-weight: bold;
                  "></i>
                  <strong style="color: #333;">Flexible Repayment:</strong> <span style="color: #666;">Choose repayment terms that suit your budget</span>
                </li>
              </ul>
            </div>

            <!-- Benefits Section -->
            <div class="loan-benefits-card" style="
              background: white;
              border-radius: 12px;
              padding: 40px;
              box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            " data-wow-delay="0.3s">
              <h3 style="
                font-size: 22px;
                color: #333;
                margin-bottom: 25px;
                font-weight: 700;
              ">Why Choose This Loan?</h3>

              <div class="row">
                <div class="col-12 col-md-6 mb-4" class="wow fadeInUp" data-wow-delay="0.4s">
                  <div style="text-align: center;">
                    <div style="
                      width: 60px;
                      height: 60px;
                      background: #f0f8f4;
                      border-radius: 50%;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                      margin: 0 auto 15px;
                    ">
                      <i class="fas fa-lightning" style="font-size: 24px; color: #007b40;"></i>
                    </div>
                    <h4 style="color: #333; margin-bottom: 10px; font-weight: 600;">Quick Approval</h4>
                    <p style="color: #666; font-size: 14px;">Fast processing and approval within 48 hours</p>
                  </div>
                </div>

                <div class="col-12 col-md-6 mb-4" class="wow fadeInUp" data-wow-delay="0.5s">
                  <div style="text-align: center;">
                    <div style="
                      width: 60px;
                      height: 60px;
                      background: #f0f8f4;
                      border-radius: 50%;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                      margin: 0 auto 15px;
                    ">
                      <i class="fas fa-shield-alt" style="font-size: 24px; color: #007b40;"></i>
                    </div>
                    <h4 style="color: #333; margin-bottom: 10px; font-weight: 600;">Secure & Safe</h4>
                    <p style="color: #666; font-size: 14px;">Protected with insurance and transparent terms</p>
                  </div>
                </div>

                <div class="col-12 col-md-6 mb-4" class="wow fadeInUp" data-wow-delay="0.6s">
                  <div style="text-align: center;">
                    <div style="
                      width: 60px;
                      height: 60px;
                      background: #f0f8f4;
                      border-radius: 50%;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                      margin: 0 auto 15px;
                    ">
                      <i class="fas fa-hand-holding-usd" style="font-size: 24px; color: #007b40;"></i>
                    </div>
                    <h4 style="color: #333; margin-bottom: 10px; font-weight: 600;">Affordable Rates</h4>
                    <p style="color: #666; font-size: 14px;">Competitive interest rates for all loan types</p>
                  </div>
                </div>

                <div class="col-12 col-md-6" class="wow fadeInUp" data-wow-delay="0.7s">
                  <div style="text-align: center;">
                    <div style="
                      width: 60px;
                      height: 60px;
                      background: #f0f8f4;
                      border-radius: 50%;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                      margin: 0 auto 15px;
                    ">
                      <i class="fas fa-redo" style="font-size: 24px; color: #007b40;"></i>
                    </div>
                    <h4 style="color: #333; margin-bottom: 10px; font-weight: 600;">Flexible Terms</h4>
                    <p style="color: #666; font-size: 14px;">Choose repayment schedule that fits your needs</p>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Sidebar -->
          <div class="col-12 col-lg-4">
            <!-- Fee Breakdown Card -->
            <div class="fee-breakdown-card" style="
              background: white;
              border-radius: 12px;
              padding: 30px;
              margin-bottom: 30px;
              box-shadow: 0 2px 10px rgba(0,0,0,0.08);
              border-top: 4px solid #007b40;
            " data-wow-delay="0.2s">
              <h3 style="
                font-size: 18px;
                color: #333;
                margin-bottom: 20px;
                font-weight: 700;
              ">Fee Breakdown</h3>

              <div class="fee-item" style="
                padding: 15px;
                background: #f5f5f5;
                border-radius: 8px;
                margin-bottom: 15px;
              ">
                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                  <span style="font-size: 13px; color: #666; font-weight: 500;">Interest Rate</span>
                  <span style="font-size: 14px; font-weight: 700; color: #007b40;"><?php echo htmlspecialchars($loan['interest_rate_monthly']); ?>%</span>
                </div>
                <small style="color: #999; font-size: 12px;">Per month</small>
              </div>

              <div class="fee-item" style="
                padding: 15px;
                background: #f5f5f5;
                border-radius: 8px;
                margin-bottom: 15px;
              ">
                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                  <span style="font-size: 13px; color: #666; font-weight: 500;">Processing Fee</span>
                  <span style="font-size: 14px; font-weight: 700; color: #333;"><?php echo htmlspecialchars($loan['processing_fee']); ?>%</span>
                </div>
                <small style="color: #999; font-size: 12px;">One-time charge</small>
              </div>

              <div class="fee-item" style="
                padding: 15px;
                background: #f5f5f5;
                border-radius: 8px;
              ">
                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                  <span style="font-size: 13px; color: #666; font-weight: 500;">Insurance Fee</span>
                  <span style="font-size: 14px; font-weight: 700; color: #333;"><?php echo htmlspecialchars($loan['insurance_fee_yearly']); ?>%</span>
                </div>
                <small style="color: #999; font-size: 12px;">Per year</small>
              </div>
            </div>

            <!-- Apply Now Card -->
            <div class="apply-card" style="
              background: linear-gradient(135deg, #007b40 0%, #005a2e 100%);
              border-radius: 12px;
              padding: 30px;
              text-align: center;
              color: white;
              box-shadow: 0 2px 10px rgba(0,123,64,0.2);
            " data-wow-delay="0.3s">
              <h3 style="
                font-size: 20px;
                margin-bottom: 15px;
                font-weight: 700;
              ">Ready to Apply?</h3>
              <p style="
                font-size: 14px;
                line-height: 1.6;
                margin-bottom: 25px;
                opacity: 0.9;
              ">Start your application now and get approved quickly with our simple online process.</p>
              <a href="loan_application.php" style="
                display: block;
                background: white;
                color: #007b40;
                padding: 12px 20px;
                border-radius: 50px;
                font-weight: 600;
                text-decoration: none;
                transition: all 0.3s ease;
                font-size: 15px;
              " onmouseover="this.style.transform='scale(1.05)';" onmouseout="this.style.transform='scale(1)';">
                Apply Now
              </a>
            </div>

            <!-- Back Link -->
            <div style="text-align: center; margin-top: 30px;">
              <a href="loans.php" style="
                color: #007b40;
                text-decoration: none;
                font-weight: 600;
                font-size: 14px;
                transition: all 0.3s ease;
              " onmouseover="this.style.textDecoration='underline';" onmouseout="this.style.textDecoration='none';">
                <i class="fas fa-arrow-left" style="margin-right: 8px;"></i>Back to All Loans
              </a>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End Loan Detail Section -->

    <!-- Start CTA Section -->
    <section class="cta-section" style="
      background: linear-gradient(135deg, #007b40 0%, #005a2e 100%);
      padding: 80px 0;
      position: relative;
      overflow: hidden;
    ">
      <div class="overlay-pattern-image-bg" style="opacity: 0.1;"></div>
      <div class="container" style="position: relative; z-index: 2;">
        <div class="row align-items-center">
          <div class="col-12 col-lg-8">
            <h2 style="
              font-size: 36px;
              color: white;
              margin-bottom: 15px;
              font-weight: 700;
            " class="wow fadeInLeft" data-wow-delay="0.2s">Have Questions About This Loan?</h2>
            <p style="
              font-size: 16px;
              color: rgba(255,255,255,0.9);
              margin-bottom: 0;
              line-height: 1.7;
            " class="wow fadeInLeft" data-wow-delay="0.4s;">Contact our loan specialists who can help answer any questions and guide you through the application process.</p>
          </div>
          <div class="col-12 col-lg-4 text-lg-end mt-4 mt-lg-0">
            <a href="contact.php" class="btn-solid" style="
              background: white;
              color: #007b40;
              padding: 15px 40px;
              border-radius: 50px;
              font-weight: 600;
              text-decoration: none;
              display: inline-block;
              transition: all 0.3s ease;
              font-size: 16px;
            " onmouseover="this.style.transform='scale(1.05)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.2)';" onmouseout="this.style.transform='scale(1)'; this.style.boxShadow='none';" class="wow fadeInRight" data-wow-delay="0.2s">Contact Us</a>
          </div>
        </div>
      </div>
    </section>
    <!-- End CTA Section -->

    <?php include_once('layout/footer.php'); ?>
