
<?php include_once('layout/header.php'); ?>

<?php
// Get search query
$search = isset($_GET['search']) ? $con->clean($_GET['search']) : '';

// Build conditions array
$conditions = array('where' => 'status = 1 and  a.blog_category = b.category_id');
if ($search) {
    $conditions['where'] .= " AND (blog_title LIKE '%$search%' OR blog_content LIKE '%$search%')";
}
$conditions['order_by'] = 'date_posted DESC';

// Fetch posts using DB class
$posts = $con->getRows('blog_posts a, blog_categories b', $conditions);

// Get all categories for sidebar
$allPosts = $con->getRows('blog_posts', array('where' => 'status = 1'));
$categories = array();
if ($allPosts) {
    foreach ($allPosts as $post) {
        if (!in_array($post['blog_category'], $categories)) {
            $categories[] = $post['blog_category'];
        }
    }
}

// Get recent posts for sidebar
$recentPosts = $con->getRows('blog_posts', array(
    'where' => 'status = 1',
    'order_by' => 'date_posted DESC',
    'limit' => 4
));
?>

<style>
  .blog-card {
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    background: white;
  }

  .blog-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 12px 24px rgba(0, 123, 64, 0.15);
  }

  .blog-card .blog-image {
    position: relative;
    overflow: hidden;
    height: 240px;
  }

  .blog-card .blog-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s ease;
  }

  .blog-card:hover .blog-image img {
    transform: scale(1.05);
  }

  .blog-card .blog-content {
    padding: 20px;
  }

  .blog-card .blog-title {
    font-size: 16px;
    font-weight: 700;
    color: #007b40;
    margin: 0 0 12px 0;
    line-height: 1.4;
    height: 2.8em;
    overflow: hidden;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
  }

  .blog-card .blog-meta {
    display: flex;
    flex-wrap: wrap;
    gap: 12px;
    margin-bottom: 15px;
    padding-bottom: 15px;
    border-bottom: 1px solid #f0f0f0;
    font-size: 12px;
    color: #999;
  }

  .blog-card .blog-meta-item {
    display: flex;
    align-items: center;
    gap: 6px;
  }

  .blog-card .blog-meta-item i {
    color: #007b40;
    width: 12px;
  }

  .blog-card .blog-excerpt {
    font-size: 13px;
    color: #666;
    line-height: 1.6;
    margin-bottom: 15px;
    height: 2.6em;
    overflow: hidden;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
  }

  .blog-card .read-more-btn {
    display: inline-block;
    background-color: #007b40;
    color: white;
    padding: 10px 16px;
    border-radius: 4px;
    text-decoration: none;
    font-size: 13px;
    font-weight: 600;
    transition: all 0.3s ease;
    border: 2px solid #007b40;
  }

  .blog-card .read-more-btn:hover {
    background-color: #005a2f;
    border-color: #005a2f;
    text-decoration: none;
  }
</style>

<!-- Start inner Page hero-->
<section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
  <div class="overlay-color"></div>
  <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
    <div class="container">
      <div class="row">
        <div class="col-12 hero-text-area ">
          <h1 class="hero-title wow fadeInUp" data-wow-delay=".2s">Blog & News</h1>
          <nav aria-label="breadcrumb ">
            <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
              <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
              <li class="breadcrumb-item active">blog</li>
            </ul>
          </nav>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- End inner Page hero-->

<!-- Start Blog Section -->
<section class="blog-section mega-section">
  <div class="container">
    <div class="row">
      <div class="col-12 col-lg-12">
        <div style="margin-bottom: 40px;">
          <h2 style="color: #007b40; margin-bottom: 15px; font-size: 2.2rem; font-weight: 700;">Latest News & Articles</h2>
          <p style="color: #666; font-size: 16px;">
            Stay updated with our latest news, insights, and stories from Sunbird Sacco.
          </p>
        </div>

        <!-- Search Bar -->
        <div style="background: white; padding: 20px; border-radius: 8px; margin-bottom: 30px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
          <form method="GET" action="" style="display: flex; gap: 10px;">
            <input type="text" name="search" class="form-control" placeholder="Search articles..." value="<?php echo htmlspecialchars($search); ?>" style="flex: 1; border: 1px solid #e0e0e0; padding: 12px 15px; border-radius: 4px;">
            <button type="submit" class="btn" style="background-color: #007b40; color: white; border: none; padding: 12px 24px; border-radius: 4px; cursor: pointer; font-weight: 600; transition: all 0.3s ease;"
                    onmouseover="this.style.backgroundColor='#005a2f';"
                    onmouseout="this.style.backgroundColor='#007b40';">
              <i class="fas fa-search"></i> Search
            </button>
          </form>
        </div>

        <!-- Posts Grid -->
        <?php if (!empty($posts)): ?>
          <div class="row">
            <?php foreach ($posts as $post):
              $postDate = new DateTime($post['date_posted']);
            ?>
            <div class="col-12 col-md-4" style="margin-bottom: 30px;">
              <div class="blog-card">
                <!-- Blog Image -->
                <a href="post-detail.php?id=<?php echo $post['blog_id']; ?>&link=<?php echo $post['post_link']; ?>" style="text-decoration: none;">
                  <div class="blog-image">
                    <img src="assets/uploads/news/thumbs/<?php echo htmlspecialchars($post['post_thumb']); ?>" alt="<?php echo htmlspecialchars($post['blog_title']); ?>">
                  </div>
                </a>

                <!-- Blog Content -->
                <div class="blog-content">
                  <a href="post-detail.php?id=<?php echo $post['blog_id']; ?>&link=<?php echo $post['post_link']; ?>" style="text-decoration: none; color: inherit;">
                    <h4 class="blog-title"><?php echo htmlspecialchars($post['blog_title']); ?></h4>
                  </a>

                  <div class="blog-meta">
                    <div class="blog-meta-item">
                      <i class="fas fa-calendar-alt"></i>
                      <span><?php echo $con->formatDate($post['date_posted']); ?></span>
                    </div>
                    <div class="blog-meta-item">
                      <i class="fas fa-folder-open"></i>
                      <span><?php echo htmlspecialchars($post['category']); ?></span>
                    </div>
                  </div>

                  <a href="post-detail.php?id=<?php echo $post['blog_id']; ?>&link=<?php echo $post['post_link']; ?>" class="read-more-btn">
                    <i class="fas fa-arrow-right" style="margin-right: 6px;"></i>Read More
                  </a>
                </div>
              </div>
            </div>
            <?php endforeach; ?>
          </div>
        <?php else: ?>
          <div style="text-align: center; padding: 60px 20px; background: white; border-radius: 8px;">
            <i class="fas fa-newspaper" style="font-size: 64px; color: #ddd; margin-bottom: 20px; display: block;"></i>
            <h4 style="color: #999; margin-bottom: 10px; font-size: 1.3rem;">No Articles Found</h4>
            <p style="color: #bbb; font-size: 15px;">
              <?php echo $search ? 'No articles match your search. Try different keywords.' : 'No articles available at the moment. Check back soon!'; ?>
            </p>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</section>
<!-- End Blog Section -->

<?php include_once('layout/footer.php'); ?>