<?php include_once('layout/header.php'); ?>
    <!--End Page Header-->
    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">Individual Loan Application</h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item active">Loan Application</li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->
    
    <!-- Start Loan Application Form Section -->
    <section class="loan-application mega-section">
      <div class="container">
        <div class="row">
          <div class="col-12 col-lg-9 mx-auto">
            <!-- Progress Bar -->
            <div class="progress-container">
              <div class="progress-bar-wrapper">
                <div class="progress-bar" id="progressBar"></div>
              </div>
              <div class="progress-steps">
                <div class="progress-step active" data-step="1">
                  <div class="step-number">1</div>
                  <div class="step-label">Loan Type</div>
                </div>
                <div class="progress-step" data-step="2">
                  <div class="step-number">2</div>
                  <div class="step-label">Personal Info</div>
                </div>
                <div class="progress-step" data-step="3">
                  <div class="step-number">3</div>
                  <div class="step-label">Bank Details</div>
                </div>
                <div class="progress-step" data-step="4">
                  <div class="step-number">4</div>
                  <div class="step-label">Loan Info</div>
                </div>
                <div class="progress-step" data-step="5">
                  <div class="step-number">5</div>
                  <div class="step-label">Guarantor</div>
                </div>
                <div class="progress-step" data-step="6">
                  <div class="step-number">6</div>
                  <div class="step-label">Declaration</div>
                </div>
              </div>
            </div>

            <!-- Application Form -->
            <form id="loanApplicationForm" class="application-form" enctype="multipart/form-data">
              
              <!-- Step 1: Loan Type Selection -->
              <div class="form-step active" data-step="1">
                <div class="step-header">
                  <h2>Select Loan Type</h2>
                  <p>Choose the type of loan you are applying for</p>
                </div>

                <div class="form-section">
                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="loanType" class="form-label">
                        <i class="fas fa-hand-holding-usd"></i> Loan Type <span class="required">*</span>
                      </label>
                      <select id="loanType" name="loan_type_id" class="form-control" required>
                        <option value="">-- Select Loan Type --</option>
                      </select>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Step 2: Personal Information -->
              <div class="form-step" data-step="2">
                <div class="step-header">
                  <h2>Personal Information</h2>
                  <p>Please provide your basic personal details</p>
                </div>

                <div class="form-section">
                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="fullName" class="form-label">
                        <i class="fas fa-user"></i> Full Name <span class="required">*</span>
                      </label>
                      <input type="text" id="fullName" name="full_name" class="form-control" placeholder="Enter your full name" required>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="saccoAccountNo" class="form-label">
                        <i class="fas fa-hashtag"></i> SACCO Account No. <span class="required">*</span>
                      </label>
                      <input type="text" id="saccoAccountNo" name="sacco_account_no" class="form-control" placeholder="Enter SACCO account number" required>
                    </div>

                    <div class="form-group">
                      <label for="employmentNo" class="form-label">
                        <i class="fas fa-hashtag"></i> Employment No.
                      </label>
                      <input type="text" id="employmentNo" name="employment_no" class="form-control" placeholder="Enter employment number">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="employerName" class="form-label">
                        <i class="fas fa-building"></i> Employer Name
                      </label>
                      <input type="text" id="employerName" name="employer_name" class="form-control" placeholder="Enter employer name">
                    </div>

                    <div class="form-group">
                      <label for="basicSalary" class="form-label">
                        <i class="fas fa-money-bill-wave"></i> Basic Salary
                      </label>
                      <div class="input-group">
                        <span class="input-group-text currency-badge">MWK</span>
                        <input type="number" id="basicSalary" name="basic_salary" class="form-control" placeholder="0.00" step="0.01">
                      </div>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="employerAddress" class="form-label">
                        <i class="fas fa-address-card"></i> Employer Address
                      </label>
                      <input type="text" id="employerAddress" name="employer_address" class="form-control" placeholder="Enter employer address">
                    </div>

                    <div class="form-group">
                      <label for="placeOfResident" class="form-label">
                        <i class="fas fa-map-marker-alt"></i> Place of Resident
                      </label>
                      <input type="text" id="placeOfResident" name="place_of_resident" class="form-control" placeholder="Enter place of residence">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="phoneNo" class="form-label">
                        <i class="fas fa-phone"></i> Phone No. <span class="required">*</span>
                      </label>
                      <input type="tel" id="phoneNo" name="phone_no" class="form-control" placeholder="Enter your phone number" required>
                    </div>

                    <div class="form-group">
                      <label for="email" class="form-label">
                        <i class="fas fa-envelope"></i> Email Address <span class="required">*</span>
                      </label>
                      <input type="email" id="email" name="email" class="form-control" placeholder="Enter your email address" required>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="occupation" class="form-label">
                        <i class="fas fa-briefcase"></i> Occupation (Job Title) <span class="required">*</span>
                      </label>
                      <input type="text" id="occupation" name="occupation" class="form-control" placeholder="Enter your occupation" required>
                    </div>

                    <div class="form-group">
                      <label for="nextOfKin" class="form-label">
                        <i class="fas fa-user-friends"></i> Next of Kin
                      </label>
                      <input type="text" id="nextOfKin" name="next_of_kin" class="form-control" placeholder="Enter next of kin">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="relation" class="form-label">
                        <i class="fas fa-link"></i> Relation
                      </label>
                      <input type="text" id="relation" name="relation" class="form-control" placeholder="E.g. Brother, Sister, Spouse">
                    </div>

                    <div class="form-group">
                      <label for="nextOfKinPhone" class="form-label">
                        <i class="fas fa-phone"></i> Next of Kin Phone Number
                      </label>
                      <input type="tel" id="nextOfKinPhone" name="next_of_kin_phone" class="form-control" placeholder="Enter phone number">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="physicalAddress" class="form-label">
                        <i class="fas fa-map-pin"></i> Physical Address
                      </label>
                      <input type="text" id="physicalAddress" name="physical_address" class="form-control" placeholder="Enter your physical address">
                    </div>
                  </div>
                </div>
              </div>

              <!-- Step 3: Member Bank Details -->
              <div class="form-step" data-step="3">
                <div class="step-header">
                  <h2>Member Bank Details</h2>
                  <p>Provide your banking information</p>
                </div>

                <div class="form-section">
                  <p class="bank-disclaimer"><strong>Note:</strong> SACCO shall not be liable for any misstatement presented herein regarding bank details.</p>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="bankName" class="form-label">
                        <i class="fas fa-bank"></i> Bank Name
                      </label>
                      <input type="text" id="bankName" name="bank_name" class="form-control" placeholder="Enter bank name">
                    </div>

                    <div class="form-group">
                      <label for="bankAccountNo" class="form-label">
                        <i class="fas fa-hashtag"></i> Bank Account No.
                      </label>
                      <input type="text" id="bankAccountNo" name="bank_account_no" class="form-control" placeholder="Enter bank account number">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="accountName" class="form-label">
                        <i class="fas fa-user"></i> Account Name
                      </label>
                      <input type="text" id="accountName" name="account_name" class="form-control" placeholder="Enter account name">
                    </div>

                    <div class="form-group">
                      <label for="branchName" class="form-label">
                        <i class="fas fa-code-branch"></i> Branch Name
                      </label>
                      <input type="text" id="branchName" name="branch_name" class="form-control" placeholder="Enter branch name">
                    </div>
                  </div>
                </div>
              </div>

              <!-- Step 4: Loan Information -->
              <div class="form-step" data-step="4">
                <div class="step-header">
                  <h2>Loan Information</h2>
                  <p>Specify your loan requirements and details</p>
                </div>

                <div class="form-section">
                  <div class="form-row">
                    <div class="form-group">
                      <label for="loanAmountApplied" class="form-label">
                        <i class="fas fa-money-bill-wave"></i> Loan Amount Applied <span class="required">*</span>
                      </label>
                      <div class="input-group">
                        <span class="input-group-text currency-badge">MWK</span>
                        <input type="number" id="loanAmountApplied" name="loan_amount_applied" class="form-control" placeholder="0.00" min="1000" step="100" required>
                      </div>
                    </div>

                    <div class="form-group">
                      <label for="repaymentPeriod" class="form-label">
                        <i class="fas fa-calendar-days"></i> Repayment Period <span class="required">*</span>
                      </label>
                      <div class="input-group">
                        <input type="number" id="repaymentPeriod" name="repayment_period_months" class="form-control" placeholder="12" min="1" max="60" value="12" required>
                        <span class="input-group-text period-badge">months</span>
                      </div>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="totalInterest" class="form-label">
                        <i class="fas fa-percent"></i> Total Interest
                      </label>
                      <div class="input-group">
                        <span class="input-group-text currency-badge">MWK</span>
                        <input type="number" id="totalInterest" name="total_interest" class="form-control" placeholder="0.00" step="0.01" readonly>
                      </div>
                    </div>

                    <div class="form-group">
                      <label for="monthlyRepayment" class="form-label">
                        <i class="fas fa-receipt"></i> Monthly Repayment Amount
                      </label>
                      <div class="input-group">
                        <span class="input-group-text currency-badge">MWK</span>
                        <input type="number" id="monthlyRepayment" name="monthly_repayment_amount" class="form-control" placeholder="0.00" step="0.01" readonly>
                      </div>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="totalRepayment" class="form-label">
                        <i class="fas fa-money-bill-wave"></i> Total Repayment Amount
                      </label>
                      <div class="input-group">
                        <span class="input-group-text currency-badge">MWK</span>
                        <input type="number" id="totalRepayment" name="total_repayment_amount" class="form-control" placeholder="0.00" step="0.01" readonly>
                      </div>
                    </div>

                    <div class="form-group">
                      <label for="appliedDate" class="form-label">
                        <i class="fas fa-calendar"></i> Applied Date <span class="required">*</span>
                      </label>
                      <input type="date" id="appliedDate" name="applied_date" class="form-control" required>
                    </div>
                  </div>

                  <!-- Assets to be Pledged -->
                  <h4 style="margin-top: 25px; margin-bottom: 15px; color: #007b40; font-weight: 600;">Assets to be Pledged as Security</h4>
                  <div class="assets-table">
                    <table>
                      <thead>
                        <tr>
                          <th style="width: 5%;">No</th>
                          <th style="width: 65%;">Name of item; Serial No; Make; (Other Necessary Description)</th>
                          <th style="width: 30%;">Value in MK</th>
                        </tr>
                      </thead>
                      <tbody id="assetsTableBody">
                        <tr>
                          <td>1</td>
                          <td><input type="text" name="asset_name[]" class="form-control asset-input" placeholder="Describe asset"></td>
                          <td><input type="number" name="asset_value[]" class="form-control asset-input" placeholder="Value" step="0.01"></td>
                        </tr>
                        <tr>
                          <td>2</td>
                          <td><input type="text" name="asset_name[]" class="form-control asset-input" placeholder="Describe asset"></td>
                          <td><input type="number" name="asset_value[]" class="form-control asset-input" placeholder="Value" step="0.01"></td>
                        </tr>
                        <tr>
                          <td>3</td>
                          <td><input type="text" name="asset_name[]" class="form-control asset-input" placeholder="Describe asset"></td>
                          <td><input type="number" name="asset_value[]" class="form-control asset-input" placeholder="Value" step="0.01"></td>
                        </tr>
                        <tr>
                          <td>4</td>
                          <td><input type="text" name="asset_name[]" class="form-control asset-input" placeholder="Describe asset"></td>
                          <td><input type="number" name="asset_value[]" class="form-control asset-input" placeholder="Value" step="0.01"></td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>

              <!-- Step 5: Guarantor Information -->
              <div class="form-step" data-step="5">
                <div class="step-header">
                  <h2>Loan Guarantor Details</h2>
                  <p>Provide details for your loan guarantor</p>
                </div>

                <div class="form-section">
                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="guarantorFullName" class="form-label">
                        <i class="fas fa-user"></i> Full Name
                      </label>
                      <input type="text" id="guarantorFullName" name="guarantor_full_name" class="form-control" placeholder="Enter guarantor full name">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="guarantorEmployerName" class="form-label">
                        <i class="fas fa-building"></i> Employer Name
                      </label>
                      <input type="text" id="guarantorEmployerName" name="guarantor_employer_name" class="form-control" placeholder="Enter employer name">
                    </div>

                    <div class="form-group">
                      <label for="guarantorPhoneNo" class="form-label">
                        <i class="fas fa-phone"></i> Phone No
                      </label>
                      <input type="tel" id="guarantorPhoneNo" name="guarantor_phone_no" class="form-control" placeholder="Enter phone number">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="guarantorPostalAddress" class="form-label">
                        <i class="fas fa-address-card"></i> Postal Address
                      </label>
                      <input type="text" id="guarantorPostalAddress" name="guarantor_postal_address" class="form-control" placeholder="Enter postal address">
                    </div>

                    <div class="form-group">
                      <label for="guarantorIdNo" class="form-label">
                        <i class="fas fa-id-card"></i> ID No
                      </label>
                      <input type="text" id="guarantorIdNo" name="guarantor_id_no" class="form-control" placeholder="Enter ID number">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="guarantorPhysicalAddress" class="form-label">
                        <i class="fas fa-map-pin"></i> Physical Address
                      </label>
                      <input type="text" id="guarantorPhysicalAddress" name="guarantor_physical_address" class="form-control" placeholder="Enter physical address">
                    </div>
                  </div>
                </div>
              </div>

              <!-- Step 6: Declaration & Signatures -->
              <div class="form-step" data-step="6">
                <div class="step-header">
                  <h2>Acceptance & Declaration</h2>
                  <p>Review and accept the loan application terms</p>
                </div>

                <div class="form-section">
                  <div class="declaration-box">
                    <h4>Acceptance and Declaration of Applicant</h4>
                    <p>I hereby declare that the above particulars are true to the best of my knowledge and belief and that I agree to abide by the conditions of the Society Loaning policy. I further declare that I have understood the terms of the loan. I hereby authorize the necessary deductions to be made from my salary. I fully understand and accept that in case of default, my shares may be used to offset the outstanding loan. Should the monies be insufficient to clear the loans, the item purchased with the loan shall form part of security and Sunbird Tourism SACCO is obliged to take custody thereof including the assets which are pledged as security. All items may be sold to recover expenses.</p>
                  </div>

                  <div class="form-row">
                    <div class="form-group">
                      <label for="applicantSignatureDate" class="form-label">
                        <i class="fas fa-calendar"></i> Applicant Signature Date
                      </label>
                      <input type="date" id="applicantSignatureDate" name="applicant_signature_date" class="form-control">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="applicantSignatureFile" class="form-label">
                        <i class="fas fa-file-upload"></i> Applicant Signature <span class="required">*</span>
                      </label>
                      <div class="file-upload-wrapper">
                        <input type="file" id="applicantSignatureFile" name="applicant_signature_file" class="form-control file-input" accept="image/*,.pdf" required>
                        <div class="file-upload-hint">
                          <i class="fas fa-cloud-upload-alt"></i>
                          <p>Upload signature or digital signature proof</p>
                          <small>Accepted formats: JPG, PNG, PDF (Max 5MB)</small>
                        </div>
                      </div>
                    </div>
                  </div>

                  <hr style="margin: 30px 0; border: none; border-top: 2px solid #f0f0f0;">

                  <div class="form-row">
                    <div class="form-group">
                      <label for="witnessName" class="form-label">
                        <i class="fas fa-user-tie"></i> Witness Name (Employer Representative)
                      </label>
                      <input type="text" id="witnessName" name="witness_name" class="form-control" placeholder="Enter witness name">
                    </div>

                    <div class="form-group">
                      <label for="witnessSignatureDate" class="form-label">
                        <i class="fas fa-calendar"></i> Witness Signature Date
                      </label>
                      <input type="date" id="witnessSignatureDate" name="witness_signature_date" class="form-control">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="witnessSignatureFile" class="form-label">
                        <i class="fas fa-file-upload"></i> Witness Signature
                      </label>
                      <div class="file-upload-wrapper">
                        <input type="file" id="witnessSignatureFile" name="witness_signature_file" class="form-control file-input" accept="image/*,.pdf">
                        <div class="file-upload-hint">
                          <i class="fas fa-cloud-upload-alt"></i>
                          <p>Upload witness signature proof</p>
                          <small>Accepted formats: JPG, PNG, PDF (Max 5MB)</small>
                        </div>
                      </div>
                    </div>
                  </div>

                  <hr style="margin: 30px 0; border: none; border-top: 2px solid #f0f0f0;">

                  <div class="form-row">
                    <div class="form-group">
                      <label for="hrManagerName" class="form-label">
                        <i class="fas fa-user-tie"></i> HR/Finance Manager Name
                      </label>
                      <input type="text" id="hrManagerName" name="hr_finance_manager_name" class="form-control" placeholder="Enter manager name">
                    </div>

                    <div class="form-group">
                      <label for="hrManagerDate" class="form-label">
                        <i class="fas fa-calendar"></i> HR/Finance Manager Date
                      </label>
                      <input type="date" id="hrManagerDate" name="hr_finance_manager_date" class="form-control">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="hrManagerSignatureFile" class="form-label">
                        <i class="fas fa-file-upload"></i> HR/Finance Manager Signature
                      </label>
                      <div class="file-upload-wrapper">
                        <input type="file" id="hrManagerSignatureFile" name="hr_finance_manager_signature_file" class="form-control file-input" accept="image/*,.pdf">
                        <div class="file-upload-hint">
                          <i class="fas fa-cloud-upload-alt"></i>
                          <p>Upload manager signature proof</p>
                          <small>Accepted formats: JPG, PNG, PDF (Max 5MB)</small>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group full-width">
                      <label for="loanRecommendation" class="form-label">
                        <i class="fas fa-comment"></i> Loan Recommendations
                      </label>
                      <textarea id="loanRecommendation" name="loan_recommendation" class="form-control" placeholder="Enter any loan recommendations" rows="3"></textarea>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Form Navigation Buttons -->
              <div class="form-navigation">
                <button type="button" class="btn btn-secondary" id="prevBtn" style="display: none;">
                  <i class="fas fa-arrow-left"></i> Previous
                </button>
                <button type="button" class="btn btn-primary" id="nextBtn">
                  Next <i class="fas fa-arrow-right"></i>
                </button>
                <button type="submit" class="btn btn-success" id="submitBtn" style="display: none;">
                  <i class="fas fa-check"></i> Submit Application
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </section>
    <!-- End Loan Application Form Section -->
    
    <?php include_once('layout/footer.php'); ?>
    
    <!-- Stylesheets -->
    <link rel="stylesheet" href="css/loan-application.css">
    
    <!-- Scripts -->
    <script src="js/loan-application.js"></script>