<?php include_once('layout/header.php'); ?>
<?php
// Fetch FAQs from database
$faqs = $con->getRows('faqs', array('order_by' => 'faq_id ASC'));
?>
    <!--End Page Header-->
    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">FAQ</h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="#0"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item active">faq</li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->
    <!-- Start  faq-1 section-->
    <section class="faq mega-section" id="faq">
      <div class="shape-top-left"></div>
      <div class="shape-bottom-right"></div>
      <div class="pattern-top-end-dir"></div>
      <div class="pattern-bottom-start-dir"></div>
      <div class="container">
        <div class="section-heading center-heading">
          <h2 class="section-title  wow fadeInUp" data-wow-delay=".2s">frequently asked questions<span class="title-design-element "></span></h2>
          <div class="line line-on-center wow fadeIn" data-wow-delay=".7s"></div>
        </div>
        <!--Start Accordion List For FAQ-->
        <div class="faq-accordion wow fadeInUp " id="accordion" data-wow-delay="0.4s">
          <div class="row">
            <div class="col-12 col-lg-6">
              <?php
              // Display FAQs in 2 columns
              if ($faqs) {
                $faqCount = 0;
                $faqsPerColumn = ceil(count($faqs) / 2);
                foreach ($faqs as $index => $faq) {
                  if ($index < $faqsPerColumn) {
                    $headingId = 'heading-' . ($index + 1);
                    $collapseId = 'collapse-' . ($index + 1);
                    ?>
              <!-- FAQ Item -->
              <div class="card mb-2">
                <div class="card-header " id="<?php echo $headingId; ?>">
                  <h5 class="mb-0 faq-title">
                    <button class="btn btn-link  faq-btn collapsed" data-bs-toggle="collapse" data-bs-target="#<?php echo $collapseId; ?>" aria-expanded="true" aria-controls="<?php echo $collapseId; ?>"><?php echo htmlspecialchars($faq['question']); ?></button>
                  </h5>
                </div>
                <div class="collapse  " id="<?php echo $collapseId; ?>" aria-labelledby="<?php echo $headingId; ?>" data-bs-parent="#accordion">
                  <div class="card-body">
                    <p class="faq-answer">
                       <?php echo htmlspecialchars($faq['answer']); ?>
                    </p>
                  </div>
                </div>
              </div>
                    <?php
                  }
                }
              }
              ?>
            </div>
            <div class="col-12 col-lg-6">
              <?php
              // Display remaining FAQs in second column
              if ($faqs) {
                $faqsPerColumn = ceil(count($faqs) / 2);
                foreach ($faqs as $index => $faq) {
                  if ($index >= $faqsPerColumn) {
                    $headingId = 'heading-' . ($index + 1);
                    $collapseId = 'collapse-' . ($index + 1);
                    ?>
              <!-- FAQ Item -->
              <div class="card mb-2">
                <div class="card-header " id="<?php echo $headingId; ?>">
                  <h5 class="mb-0 faq-title">
                    <button class="btn btn-link  faq-btn collapsed" data-bs-toggle="collapse" data-bs-target="#<?php echo $collapseId; ?>" aria-expanded="true" aria-controls="<?php echo $collapseId; ?>"><?php echo htmlspecialchars($faq['question']); ?></button>
                  </h5>
                </div>
                <div class="collapse  " id="<?php echo $collapseId; ?>" aria-labelledby="<?php echo $headingId; ?>" data-bs-parent="#accordion">
                  <div class="card-body">
                    <p class="faq-answer">
                       <?php echo htmlspecialchars($faq['answer']); ?>
                    </p>
                  </div>
                </div>
              </div>
                    <?php
                  }
                }
              }
              ?>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End  faq-1 section-->
    <!-- Start  take-action Section-->
    <section class="take-action mega-section " id="take-action">
      <div class="overlay-photo-image-bg parallax "></div>
      <div class="overlay-color "></div>
      <div class="cta-wrapper">
        <div class="container">
          <div class="section-heading center-heading">
            <h2 class="section-title  wow fadeInUp" data-wow-delay=".2s">Still Have More <span class='hollow-text'>Questions</span>?<span class="title-design-element "></span></h2>
            <p class="section-subtitle wow fadeInUp" data-wow-delay=".6s">If you have any more questions, feel free to contact us.</p>
            <div class="line line-on-center wow fadeIn" data-wow-delay=".7s"></div>
          </div>
          <!--Start .see-more-area-->
          <div class=" see-more-area wow fadeInUp" data-wow-delay="0.8s"><a class=" btn-solid cta-link" href="contact.php">get in toutch</a></div>
          <!--End Of .see-more-area        -->
        </div>
      </div>
    </section>
    <!-- End  take-action Section-->
    <?php include_once('layout/footer.php'); ?>