<?php include_once('layout/header.php'); ?>

<?php
$event_id = isset($_GET['event']) ? intval($_GET['event']) : 0;

if ($event_id === 0) {
    header('Location: upcoming_events.php');
    exit;
}

// Fetch event details using DB class
$event = $con->getRows('events', array(
    'where' => array('event_id' => $event_id, 'status' => 1),
    'return_type' => 'single'
));

if (!$event) {
    header('Location: upcoming_events.php');
    exit;
}

$eventDate = new DateTime($event['date']);
$today = new DateTime();
$isPast = $eventDate < $today;
$daysUntil = $today->diff($eventDate)->days;

// Get other upcoming events (excluding current)
$otherEvents = $con->getRows('events', array(
    'where' => 'status = 1 AND event_id != ' . $event_id,
    'order_by' => 'date ASC',
    'limit' => 5
));
?>

    <!-- Start inner Page hero-->
    <section class="d-flex align-items-center page-hero hero-vegas-slider inner-page-hero " id="page-hero">
      <div class="overlay-color"></div>
      <div class="vegas-slider-content" data-vegas-slide-1="assets/images/hero/vegas-slider/1.jpg" data-vegas-slide-2="assets/images/hero/vegas-slider/2.jpg" data-vegas-slide-3="assets/images/hero/vegas-slider/3.jpg">
        <div class="container">
          <div class="row">
            <div class="col-12 hero-text-area ">
              <h1 class="hero-title  wow fadeInUp" data-wow-delay=".2s">Event Details</h1>
              <nav aria-label="breadcrumb ">
                <ul class="breadcrumb wow fadeInUp" data-wow-delay=".6s">
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="index.php"><i class="fas fa-home icon "></i>home</a></li>
                  <li class="breadcrumb-item"><a class="breadcrumb-link" href="upcoming_events.php">Events</a></li>
                  <li class="breadcrumb-item active"><?php echo htmlspecialchars($event['title']); ?></li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End inner Page hero-->

    <!-- Start Event Details Section -->
    <section class="event-details-section mega-section">
      <div class="container">
        <div class="row">
          <div class="col-12 col-lg-8">
            <!-- Event Article -->
            <article class="event-article">
              <!-- Event Header with Image -->
              <div class="event-hero-image" style="margin-bottom: 30px; position: relative; border-radius: 8px; overflow: hidden; box-shadow: 0 4px 12px rgba(0, 123, 64, 0.15);">
                <img src="assets/uploads/events/images/<?php echo htmlspecialchars($event['image']); ?>" alt="<?php echo htmlspecialchars($event['title']); ?>" style="width: 100%; height: auto; display: block;">
                
                <!-- Status Overlay -->
                <div style="position: absolute; top: 20px; right: 20px; background: rgba(0, 123, 64, 0.95); color: white; padding: 12px 20px; border-radius: 20px; font-size: 13px; font-weight: 600; text-transform: uppercase; display: flex; align-items: center; gap: 8px; backdrop-filter: blur(10px);">
                  <?php if ($isPast): ?>
                    <i class="fas fa-calendar-times"></i> Past Event
                  <?php else: ?>
                    <i class="fas fa-hourglass-end"></i> <?php echo $daysUntil; ?> days to go
                  <?php endif; ?>
                </div>
              </div>

              <!-- Event Header -->
              <div class="event-header" style="margin-bottom: 30px; padding-bottom: 25px; border-bottom: 2px solid #f0f0f0;">
                <div style="display: flex; gap: 15px; align-items: flex-start; margin-bottom: 20px;">
                  <div style="background: linear-gradient(135deg, #007b40 0%, #005a2f 100%); color: white; padding: 20px; border-radius: 8px; flex-shrink: 0;">
                    <i class="fas fa-calendar-alt" style="font-size: 28px;"></i>
                  </div>
                  <div style="flex: 1;">
                    <h1 style="color: #007b40; margin: 0 0 10px 0; font-size: 2.2rem; line-height: 1.3; font-weight: 700;">
                      <?php echo htmlspecialchars($event['title']); ?>
                    </h1>
                    <p style="margin: 0; color: #999; font-size: 14px;">
                      <i class="fas fa-map-marker-alt" style="margin-right: 6px;"></i><?php echo htmlspecialchars($event['venue']); ?> • 
                      <?php echo $eventDate->format('d F, Y'); ?>
                    </p>
                  </div>
                </div>

                <div style="display: flex; gap: 12px; flex-wrap: wrap; align-items: center;">
                  <span style="background: <?php echo $isPast ? '#f8d7da' : '#d4edda'; ?>; color: <?php echo $isPast ? '#721c24' : '#155724'; ?>; padding: 8px 16px; border-radius: 20px; font-size: 13px; font-weight: 600; text-transform: uppercase; display: flex; align-items: center; gap: 6px;">
                    <i class="fas fa-<?php echo $isPast ? 'lock' : 'check-circle'; ?>"></i>
                    <?php echo $isPast ? 'Event Completed' : 'Upcoming Event'; ?>
                  </span>
                </div>
              </div>

              <!-- Event Information Box -->
              <div style="background: linear-gradient(135deg, #f0f7f4 0%, #ffffff 100%); border-left: 4px solid #007b40; padding: 25px; margin-bottom: 35px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 123, 64, 0.08);">
                <div class="row">
                  <div class="col-md-6" style="margin-bottom: 20px;">
                    <div style="display: flex; gap: 12px; align-items: flex-start;">
                      <i class="fas fa-calendar-check" style="color: #007b40; font-size: 18px; margin-top: 2px; flex-shrink: 0;"></i>
                      <div>
                        <p style="margin: 0 0 6px 0; font-weight: 600; color: #999; font-size: 11px; text-transform: uppercase; letter-spacing: 0.5px;">Event Date</p>
                        <p style="margin: 0; color: #333; font-size: 15px; font-weight: 500;"><?php echo $eventDate->format('d F, Y'); ?></p>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6" style="margin-bottom: 20px;">
                    <div style="display: flex; gap: 12px; align-items: flex-start;">
                      <i class="fas fa-map-marker-alt" style="color: #007b40; font-size: 18px; margin-top: 2px; flex-shrink: 0;"></i>
                      <div>
                        <p style="margin: 0 0 6px 0; font-weight: 600; color: #999; font-size: 11px; text-transform: uppercase; letter-spacing: 0.5px;">Venue</p>
                        <p style="margin: 0; color: #333; font-size: 15px; font-weight: 500;"><?php echo htmlspecialchars($event['venue']); ?></p>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6" style="margin-bottom: 0;">
                    <div style="display: flex; gap: 12px; align-items: flex-start;">
                      <i class="fas fa-clock" style="color: #007b40; font-size: 18px; margin-top: 2px; flex-shrink: 0;"></i>
                      <div>
                        <p style="margin: 0 0 6px 0; font-weight: 600; color: #999; font-size: 11px; text-transform: uppercase; letter-spacing: 0.5px;">Posted</p>
                        <p style="margin: 0; color: #333; font-size: 15px; font-weight: 500;"><?php echo $con->formatDate($event['date_posted']); ?></p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Event Description -->
              <div class="event-content" style="line-height: 1.9; color: #444; font-size: 1rem; margin-bottom: 40px;">
                <h3 style="color: #007b40; margin: 0 0 20px 0; font-size: 1.6rem; font-weight: 700;">About This Event</h3>
                <?php echo $event['details']; ?>
              </div>

              <!-- Event Footer -->
              <div class="event-footer" style="background: linear-gradient(135deg, #f0f7f4 0%, #ffffff 100%); padding: 30px; border-radius: 8px; border-left: 4px solid #007b40; box-shadow: 0 2px 8px rgba(0, 123, 64, 0.08);">
                <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 20px;">
                  <div>
                    <h5 style="margin: 0 0 10px 0; color: #007b40; font-size: 1.1rem; font-weight: 600;">
                      <i class="fas fa-info-circle" style="margin-right: 8px;"></i>Event Information
                    </h5>
                    <p style="margin: 0; color: #666; font-size: 14px; line-height: 1.6;">
                      <?php 
                        if ($isPast) {
                          echo 'This event has already taken place. Thank you for your participation!';
                        } else {
                          echo 'Mark your calendar for this important event. Taking place at ' . htmlspecialchars($event['venue']) . ' on ' . $eventDate->format('d F, Y') . '.';
                        }
                      ?>
                    </p>
                  </div>
                  <a href="upcoming_events.php" class="btn" style="background-color: #007b40; color: white; border: none; padding: 12px 28px; border-radius: 4px; text-decoration: none; font-weight: 600; display: inline-flex; align-items: center; gap: 8px; white-space: nowrap; transition: all 0.3s ease;"
                     onmouseover="this.style.backgroundColor='#005a2f';"
                     onmouseout="this.style.backgroundColor='#007b40';">
                    <i class="fas fa-arrow-left"></i> Back to Events
                  </a>
                </div>
              </div>
            </article>
          </div>

          <!-- Sidebar -->
          <div class="col-12 col-lg-4">
            <div class="event-sidebar">
              <!-- Event Status Card -->
              <div class="sidebar-box" style="background: linear-gradient(135deg, #007b40 0%, #005a2f 100%); color: white; padding: 30px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0, 123, 64, 0.2); margin-bottom: 25px;">
                <div style="text-align: center; margin-bottom: 20px;">
                  <?php if ($isPast): ?>
                    <i class="fas fa-check-circle" style="font-size: 48px; opacity: 0.9; display: block; margin-bottom: 15px;"></i>
                    <h4 style="margin: 0; font-size: 1.8rem; font-weight: 700;">Event Completed</h4>
                    <p style="margin: 5px 0 0 0; opacity: 0.9; font-size: 14px;">Thank you for attending</p>
                  <?php else: ?>
                    <i class="fas fa-calendar-alt" style="font-size: 48px; display: block; margin-bottom: 15px;"></i>
                    <h4 style="margin: 0; font-size: 1.8rem; font-weight: 700;">Upcoming Event</h4>
                    <p style="margin: 5px 0 0 0; opacity: 0.9; font-size: 14px;">Mark your calendar</p>
                  <?php endif; ?>
                </div>

                <div style="border-top: 1px solid rgba(255,255,255,0.3); padding-top: 20px;">
                  <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div style="text-align: center;">
                      <p style="margin: 0 0 8px 0; opacity: 0.85; font-size: 12px; text-transform: uppercase; letter-spacing: 0.5px;">Date</p>
                      <h6 style="margin: 0; font-size: 16px; font-weight: 600;"><?php echo $eventDate->format('d'); ?></h6>
                      <p style="margin: 5px 0 0 0; font-size: 11px; opacity: 0.8;"><?php echo $eventDate->format('M Y'); ?></p>
                    </div>
                    <?php if (!$isPast): ?>
                    <div style="text-align: center;">
                      <p style="margin: 0 0 8px 0; opacity: 0.85; font-size: 12px; text-transform: uppercase; letter-spacing: 0.5px;">Days Left</p>
                      <h6 style="margin: 0; font-size: 16px; font-weight: 600;"><?php echo $daysUntil; ?></h6>
                      <p style="margin: 5px 0 0 0; font-size: 11px; opacity: 0.8;">to attend</p>
                    </div>
                    <?php endif; ?>
                  </div>
                </div>
              </div>

              

              <!-- Other Upcoming Events -->
              <?php if ($otherEvents): ?>
              <div class="sidebar-box" style="background: white; border: 1px solid #e0e0e0; padding: 20px; border-radius: 8px;">
                <h6 style="color: #007b40; margin: 0 0 18px 0; font-weight: 700; font-size: 14px; text-transform: uppercase; letter-spacing: 0.5px;">
                  <i class="fas fa-calendar" style="margin-right: 8px;"></i>Other Events
                </h6>
                <ul style="list-style: none; padding: 0; margin: 0; display: flex; flex-direction: column; gap: 12px;">
                  <?php foreach ($otherEvents as $other): 
                    $otherEventDate = new DateTime($other['date']);
                    $otherIsPast = $otherEventDate < $today;
                  ?>
                  <li style="border-bottom: 1px solid #f0f0f0; padding-bottom: 12px;">
                    <a href="event-details.php?event=<?php echo $other['event_id']; ?>" style="text-decoration: none; color: inherit; transition: all 0.3s ease; display: block; padding: 0; border-radius: 4px;">
                      <div style="display: flex; gap: 12px; align-items: flex-start;">
                        <div style="background: #f0f7f4; padding: 10px 12px; border-radius: 6px; flex-shrink: 0; text-align: center; min-width: 50px;">
                          <div style="font-size: 16px; font-weight: 700; color: #007b40; line-height: 1;">
                            <?php echo $otherEventDate->format('d'); ?>
                          </div>
                          <div style="font-size: 10px; color: #007b40; margin-top: 2px;">
                            <?php echo $otherEventDate->format('M'); ?>
                          </div>
                        </div>
                        <div style="flex: 1; min-width: 0;">
                          <h6 style="margin: 0 0 6px 0; font-weight: 600; color: #007b40; font-size: 13px; line-height: 1.4;">
                            <?php echo htmlspecialchars(substr($other['title'], 0, 50)); ?>
                            <?php if (strlen($other['title']) > 50) echo '...'; ?>
                          </h6>
                          <div style="display: flex; justify-content: space-between; align-items: center; gap: 8px;">
                            <span style="font-size: 11px; color: #999;">
                              <i class="fas fa-map-marker-alt" style="margin-right: 4px;"></i>
                              <?php echo htmlspecialchars(substr($other['venue'], 0, 25)); ?>
                            </span>
                            <span style="background: <?php echo $otherIsPast ? '#f8d7da' : '#d4edda'; ?>; color: <?php echo $otherIsPast ? '#721c24' : '#155724'; ?>; padding: 2px 8px; border-radius: 4px; font-size: 9px; font-weight: 600; text-transform: uppercase;">
                              <?php echo $otherIsPast ? 'Past' : 'Upcoming'; ?>
                            </span>
                          </div>
                        </div>
                      </div>
                    </a>
                  </li>
                  <?php endforeach; ?>
                </ul>
              </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End Event Details Section -->

<?php include_once('layout/footer.php'); ?>
