<?php
//session_start();
//include_once('../../config/config.php');
//include_once('../../config/class.php');
//include_once('protected.php');
include_once('header.php');

$con = new DB();

if (!isset($_GET['id'])) {
    header('Location: membership_application.php');
    exit;
}

$application_id = intval($_GET['id']);

// Fetch application details
$stmt = $db->prepare("SELECT * FROM membership_applications WHERE id = :id");
$stmt->execute([':id' => $application_id]);
$app = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$app) {
    header('Location: membership_application.php');
    exit;
}

// Decode JSON fields
$nominated_kins = json_decode($app['nominated_kins'], true) ?: [];
$referral_sources = json_decode($app['referral_sources'], true) ?: [];

?>
   

    <div class="container">
        <div class="card-deck mb-3 text-center">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mt-3 mb-3 border-bottom" style="width: 100%;">
                <h1 class="h2">Membership Application Details</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group mr-2">
                        <button class="btn btn-sm btn-outline-success" id="downloadPdfBtn" onclick="downloadPDF()">
                            <i class="fa fa-print"></i> Print
                        </button>
                        <a class="btn btn-sm btn-outline-secondary" href="membership_application.php">Back</a>
                    </div>
                </div>
            </div>

            <div id="error"></div>

            <!-- Membership Application Form -->
            <div style="width: 100%; padding: 20px; background-color: #fff;">
                <div class="row mb-4">
                    <div class="col-md-12 text-center">
                        <h3 style="margin-bottom: 5px;">SUNBIRD SACCO</h3>
                        <h5 style="margin-bottom: 10px;">MEMBERSHIP APPLICATION FORM</h5>
                        <p style="font-size: 12px; color: #666;">Application Number: <strong><?php echo htmlspecialchars($app['application_number']); ?></strong></p>
                    </div>
                </div>

                <form id="membershipApplicationForm" style="background-color: #f9f9f9; padding: 20px; border-radius: 5px;">

                    <!-- APPLICATION INFORMATION SECTION -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                                <i class="fa fa-info-circle"></i> APPLICATION INFORMATION
                            </h5>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label><strong>Application Number:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['application_number']); ?>" readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label><strong>Application Date:</strong></label>
                            <input type="text" class="form-control" value="<?php echo date('M d, Y', strtotime($app['created_at'])); ?>" readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label><strong>Status:</strong></label>
                            <div style="padding: 8px; border-radius: 4px; background-color: #f0f0f0;">
                                <span class="badge badge-<?php echo $app['application_status'] === 'approved' ? 'success' : ($app['application_status'] === 'rejected' ? 'danger' : 'warning'); ?>" style="font-size: 12px; padding: 8px 12px;">
                                    <?php echo ucfirst($app['application_status']); ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- PERSONAL INFORMATION SECTION -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                                <i class="fa fa-user"></i> PERSONAL INFORMATION
                            </h5>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label><strong>Full Name:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['full_name']); ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label><strong>Account Type:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars(ucfirst(str_replace('_', ' ', $app['account_type']))); ?>" readonly>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label><strong>ID Type:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars(ucfirst(str_replace('_', ' ', $app['id_type']))); ?>" readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label><strong>ID Number:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['id_number']); ?>" readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label><strong>Date of Birth:</strong></label>
                            <input type="text" class="form-control" value="<?php echo !empty($app['date_of_birth']) ? date('M d, Y', strtotime($app['date_of_birth'])) : 'N/A'; ?>" readonly>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label><strong>Gender:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars(ucfirst($app['gender'])); ?>" readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label><strong>Marital Status:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars(ucfirst(str_replace('_', ' ', $app['marital_status']))); ?>" readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label><strong>Branch:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['branch']); ?>" readonly>
                        </div>
                    </div>

                    <!-- CONTACT INFORMATION SECTION -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                                <i class="fa fa-phone"></i> CONTACT INFORMATION
                            </h5>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label><strong>Phone Number:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['phone_number']); ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label><strong>Email Address:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['email'] ?? 'N/A'); ?>" readonly>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label><strong>Contact Address:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['contact_address'] ?? 'N/A'); ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label><strong>Permanent Address:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['permanent_address'] ?? 'N/A'); ?>" readonly>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label><strong>Village:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['village'] ?? 'N/A'); ?>" readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label><strong>Town:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['town'] ?? 'N/A'); ?>" readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label><strong>District:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['district'] ?? 'N/A'); ?>" readonly>
                        </div>
                    </div>

                    <!-- OCCUPATION INFORMATION SECTION -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                                <i class="fa fa-briefcase"></i> OCCUPATION INFORMATION
                            </h5>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label><strong>Occupation Type:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars(ucfirst(str_replace('_', ' ', $app['occupation_type']))); ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label><strong>Institution/Business Name:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['institution_name'] ?? 'N/A'); ?>" readonly>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label><strong>Job Title/Profession:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['profession_job_title'] ?? 'N/A'); ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label><strong>Institution Phone:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['institution_phone'] ?? 'N/A'); ?>" readonly>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label><strong>Postal Address:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['institution_postal_address'] ?? 'N/A'); ?>" readonly>
                        </div>
                    </div>

                    <!-- MONTHLY CONTRIBUTIONS SECTION -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                                <i class="fa fa-money"></i> MONTHLY CONTRIBUTIONS (MWK)
                            </h5>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label><strong>Savings:</strong></label>
                            <input type="text" class="form-control" value="<?php echo number_format($app['monthly_savings'] ?? 0, 2); ?>" readonly>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label><strong>Shares:</strong></label>
                            <input type="text" class="form-control" value="<?php echo number_format($app['monthly_shares'] ?? 0, 2); ?>" readonly>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label><strong>Fixed Deposit:</strong></label>
                            <input type="text" class="form-control" value="<?php echo number_format($app['monthly_fixed_deposit'] ?? 0, 2); ?>" readonly>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label><strong>Funeral Cover:</strong></label>
                            <input type="text" class="form-control" value="<?php echo number_format($app['kangachepe_funeral_cover'] ?? 0, 2); ?>" readonly>
                        </div>
                    </div>

                    <!-- NEXT OF KIN SECTION -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                                <i class="fa fa-users"></i> NEXT OF KIN
                            </h5>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label><strong>Name:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['next_of_kin_name'] ?? 'N/A'); ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label><strong>Relationship:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['next_of_kin_relationship'] ?? 'N/A'); ?>" readonly>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label><strong>Phone Number:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['next_of_kin_phone'] ?? 'N/A'); ?>" readonly>
                        </div>
                    </div>

                    <!-- NOMINATED BENEFICIARIES SECTION -->
                    <?php if (!empty($nominated_kins)): ?>
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                                <i class="fa fa-list"></i> NOMINATED BENEFICIARIES
                            </h5>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered table-sm">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Relationship</th>
                                            <th>ID Number</th>
                                            <th>Percentage</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($nominated_kins as $kin): ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($kin['name'] ?? ''); ?></td>
                                                <td><?php echo htmlspecialchars($kin['relationship'] ?? ''); ?></td>
                                                <td><?php echo htmlspecialchars($kin['id'] ?? ''); ?></td>
                                                <td><?php echo number_format($kin['percentage'] ?? 0, 2); ?>%</td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- REFERRAL INFORMATION SECTION -->
                    <?php if (!empty($referral_sources) || !empty($app['referrer_name'])): ?>
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                                <i class="fa fa-share"></i> REFERRAL INFORMATION
                            </h5>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label><strong>How You Heard About Us:</strong></label>
                            <input type="text" class="form-control" value="<?php 
                                if (is_array($referral_sources) && !empty($referral_sources)) {
                                    echo htmlspecialchars(implode(', ', array_map('ucfirst', $referral_sources)));
                                } else {
                                    echo 'N/A';
                                }
                            ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label><strong>Referrer Name:</strong></label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($app['referrer_name'] ?? 'N/A'); ?>" readonly>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- SKETCH MAP SECTION -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                                <i class="fa fa-map"></i> SKETCH MAP
                            </h5>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label><strong>Sketch Map (Current location to home, business area, or school):</strong></label>
                            <?php if (!empty($app['sketch_map'])): ?>
                                <div style="margin-top: 10px;">
                                    <a href="../../assets/uploads/<?php echo htmlspecialchars($app['sketch_map']); ?>" target="_blank" class="btn btn-sm btn-info">
                                        <i class="fa fa-image"></i> View Sketch Map
                                    </a>
                                </div>
                                <div style="margin-top: 15px; border: 1px solid #ddd; padding: 10px; border-radius: 4px; max-width: 600px;">
                                    <img src="../../assets/uploads/<?php echo htmlspecialchars($app['sketch_map']); ?>" alt="Sketch Map" style="max-width: 100%; height: auto;">
                                </div>
                            <?php else: ?>
                                <div style="padding: 10px; background-color: #f0f0f0; border-radius: 4px; color: #666;">
                                    <i class="fa fa-exclamation-circle"></i> No sketch map uploaded
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- DECLARATION SECTION -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                                <i class="fa fa-file-text"></i> DECLARATION
                            </h5>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <table class="table table-bordered" style="margin-bottom: 0;">
                                <tbody>
                                    <tr>
                                        <td style="width: 25%;"><strong>Applicant Name:</strong></td>
                                        <td><?php echo htmlspecialchars($app['applicant_name'] ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Signature Date:</strong></td>
                                        <td><?php echo !empty($app['applicant_signature_date']) ? date('M d, Y', strtotime($app['applicant_signature_date'])) : 'N/A'; ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Signature:</strong></td>
                                        <td>
                                            <?php if (!empty($app['applicant_signature'])): ?>
                                                <div style="padding: 10px; border: 1px solid #ddd; border-radius: 4px; max-width: 300px;">
                                                    <img src="../../assets/uploads/<?php echo htmlspecialchars($app['applicant_signature']); ?>" alt="Applicant Signature" style="max-width: 100%; height: auto;">
                                                </div>
                                            <?php else: ?>
                                                <span style="color: #999;">No signature uploaded</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </form>
            </div>

        </div>

    </div>

    <!-- Bootstrap core JavaScript -->
    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
    <script>
        window.jQuery || document.write('<script src="../../js/vendor/jquery-slim.min.js"><\/script>')
    </script>
    <script src="../../js/vendor/popper.min.js"></script>
    <script src="../../js/bootstrap.min.js"></script>

    <script>
        function downloadPDF() {
            var applicationId = <?php echo $app['id']; ?>;
            window.location.href = 'download-membership-application-pdf.php?id=' + applicationId;
        }
    </script>

</body>

</html>
