<?php
session_start();
include_once('../../config/config.php');

if (!isset($_GET['id'])) {
    echo "Invalid application ID";
    exit;
}

$application_id = intval($_GET['id']);

$statement = "SELECT 
    ila.*,
    lt.loan_name,
    lt.interest_rate_monthly,
    lt.processing_fee,
    lt.insurance_fee_yearly
FROM individual_loan_applications ila
LEFT JOIN loan_types lt ON ila.loan_type_id = lt.id
WHERE ila.id = :id";

try {
    $stmt = $db->prepare($statement);
    $stmt->execute([':id' => $application_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        echo "Application not found";
        exit;
    }
?>

    <div class="application-details">
        <div class="row">
            <div class="col-md-6">
                <h6><strong>Application Number:</strong></h6>
                <p><?php echo htmlspecialchars($row['application_number']); ?></p>

                <h6><strong>Full Name:</strong></h6>
                <p><?php echo htmlspecialchars($row['full_name']); ?></p>

                <h6><strong>Email:</strong></h6>
                <p><?php echo htmlspecialchars($row['email']); ?></p>

                <h6><strong>Phone Number:</strong></h6>
                <p><?php echo htmlspecialchars($row['phone_no']); ?></p>

                <h6><strong>Sacco Account No:</strong></h6>
                <p><?php echo htmlspecialchars($row['sacco_account_no']); ?></p>

                <h6><strong>Occupation:</strong></h6>
                <p><?php echo htmlspecialchars($row['occupation'] ?? 'N/A'); ?></p>
            </div>

            <div class="col-md-6">
                <h6><strong>Loan Type:</strong></h6>
                <p><?php echo htmlspecialchars($row['loan_name'] ?? 'N/A'); ?></p>

                <h6><strong>Loan Amount Applied:</strong></h6>
                <p>KES <?php echo number_format($row['loan_amount_applied'], 2); ?></p>

                <h6><strong>Repayment Period:</strong></h6>
                <p><?php echo intval($row['repayment_period_months']); ?> months</p>

                <h6><strong>Monthly Repayment:</strong></h6>
                <p>KES <?php echo number_format($row['monthly_repayment_amount'] ?? 0, 2); ?></p>

                <h6><strong>Status:</strong></h6>
                <p>
                    <?php if ($row['status'] == 'draft'): ?>
                        <span class="badge badge-warning">Draft</span>
                    <?php else: ?>
                        <span class="badge badge-success">Submitted</span>
                    <?php endif; ?>
                </p>

                <h6><strong>Date Applied:</strong></h6>
                <p><?php echo date('M d, Y', strtotime($row['applied_date'])); ?></p>
            </div>
        </div>

        <hr>

        <div class="row">
            <div class="col-md-12">
                <h6><strong>Employer Information:</strong></h6>
                <p><strong>Employer Name:</strong> <?php echo htmlspecialchars($row['employer_name'] ?? 'N/A'); ?></p>
                <p><strong>Employment No:</strong> <?php echo htmlspecialchars($row['employment_no'] ?? 'N/A'); ?></p>
                <p><strong>Basic Salary:</strong> KES <?php echo number_format($row['basic_salary'] ?? 0, 2); ?></p>
            </div>
        </div>

        <hr>

        <div class="row">
            <div class="col-md-12">
                <h6><strong>Bank Details:</strong></h6>
                <p><strong>Bank Name:</strong> <?php echo htmlspecialchars($row['bank_name'] ?? 'N/A'); ?></p>
                <p><strong>Account Name:</strong> <?php echo htmlspecialchars($row['account_name'] ?? 'N/A'); ?></p>
                <p><strong>Account Number:</strong> <?php echo htmlspecialchars($row['bank_account_no'] ?? 'N/A'); ?></p>
                <p><strong>Branch Name:</strong> <?php echo htmlspecialchars($row['branch_name'] ?? 'N/A'); ?></p>
            </div>
        </div>

        <hr>

        <div class="row">
            <div class="col-md-12">
                <h6><strong>Next of Kin:</strong></h6>
                <p><strong>Name:</strong> <?php echo htmlspecialchars($row['next_of_kin'] ?? 'N/A'); ?></p>
                <p><strong>Phone:</strong> <?php echo htmlspecialchars($row['next_of_kin_phone'] ?? 'N/A'); ?></p>
                <p><strong>Relation:</strong> <?php echo htmlspecialchars($row['relation'] ?? 'N/A'); ?></p>
            </div>
        </div>

        <hr>

        <div class="row">
            <div class="col-md-12">
                <h6><strong>Guarantor Information:</strong></h6>
                <p><strong>Full Name:</strong> <?php echo htmlspecialchars($row['guarantor_full_name'] ?? 'N/A'); ?></p>
                <p><strong>Employer Name:</strong> <?php echo htmlspecialchars($row['guarantor_employer_name'] ?? 'N/A'); ?></p>
                <p><strong>Phone No:</strong> <?php echo htmlspecialchars($row['guarantor_phone_no'] ?? 'N/A'); ?></p>
                <p><strong>ID No:</strong> <?php echo htmlspecialchars($row['guarantor_id_no'] ?? 'N/A'); ?></p>
            </div>
        </div>

        <hr>

        <div class="row">
            <div class="col-md-12">
                <h6><strong>Assets to be Pledged as Security:</strong></h6>
                <p><?php echo htmlspecialchars($row['assets_description'] ?? 'N/A'); ?></p>
            </div>
        </div>
    </div>

<?php

} catch (PDOException $e) {
    echo "Error retrieving application: " . htmlspecialchars($e->getMessage());
}
?>
