<?php include_once('header.php'); ?>

<div class="container">
    <div class="card-deck mb-3 text-center">
        <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mt-3 mb-3 border-bottom" style="width: 100%;">
            <h1 class="h2" id="pageTitle">Loan Application Form</h1>
            <div class="btn-toolbar mb-2 mb-md-0">
                <div class="btn-group mr-2">
                    <button class="btn btn-sm btn-outline-primary" id="printBtn" onclick="window.print()">
                        <i class="fa fa-print"></i> Print
                    </button>
                    <button class="btn btn-sm btn-outline-success" id="downloadPdfBtn">
                        <i class="fa fa-file-pdf-o"></i> Download PDF
                    </button>
                    <a class="btn btn-sm btn-outline-secondary" href="individual_loan_applications.php">Back</a>
                </div>
            </div>
        </div>

        <div id="error"></div>

        <!-- Loan Application Form -->
        <div style="width: 100%; padding: 20px; background-color: #fff;">
            <div class="row mb-4">
                <div class="col-md-12 text-center">
                    <h3 style="margin-bottom: 5px;">SUNBIRD SACCO</h3>
                    <h5 style="margin-bottom: 10px;">INDIVIDUAL LOAN APPLICATION FORM</h5>
                    <p style="font-size: 12px; color: #666;">Application Number: <strong id="appNumber">--</strong></p>
                </div>
            </div>

            <form id="loanApplicationForm" class="needs-validation" style="background-color: #f9f9f9; padding: 20px; border-radius: 5px;">

                <!-- PERSONAL INFORMATION SECTION -->
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                            <i class="fa fa-user"></i> PERSONAL INFORMATION
                        </h5>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Full Name:</strong></label>
                        <input type="text" class="form-control" id="fullName" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label><strong>SACCO Account Number:</strong></label>
                        <input type="text" class="form-control" id="saccoAccountNo" readonly>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Email Address:</strong></label>
                        <input type="email" class="form-control" id="email" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label><strong>Phone Number:</strong></label>
                        <input type="tel" class="form-control" id="phoneNo" readonly>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Occupation:</strong></label>
                        <input type="text" class="form-control" id="occupation" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label><strong>Basic Salary (KES):</strong></label>
                        <input type="number" class="form-control" id="basicSalary" readonly>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Place of Residence:</strong></label>
                        <input type="text" class="form-control" id="placeOfResident" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label><strong>Physical Address:</strong></label>
                        <input type="text" class="form-control" id="physicalAddress" readonly>
                    </div>
                </div>

                <!-- EMPLOYER INFORMATION SECTION -->
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                            <i class="fa fa-building"></i> EMPLOYER INFORMATION
                        </h5>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Employer Name:</strong></label>
                        <input type="text" class="form-control" id="employerName" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label><strong>Employment Number:</strong></label>
                        <input type="text" class="form-control" id="employmentNo" readonly>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <label><strong>Employer Address:</strong></label>
                        <input type="text" class="form-control" id="employerAddress" readonly>
                    </div>
                </div>

                <!-- LOAN INFORMATION SECTION -->
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                            <i class="fa fa-money"></i> LOAN INFORMATION
                        </h5>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Loan Type:</strong></label>
                        <input type="text" class="form-control" id="loanType" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label><strong>Amount Applied (KES):</strong></label>
                        <input type="number" class="form-control" id="loanAmountApplied" readonly>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label><strong>Repayment Period (Months):</strong></label>
                        <input type="number" class="form-control" id="repaymentPeriodMonths" readonly>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label><strong>Monthly Repayment (KES):</strong></label>
                        <input type="number" class="form-control" id="monthlyRepaymentAmount" readonly>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label><strong>Total Repayment (KES):</strong></label>
                        <input type="number" class="form-control" id="totalRepaymentAmount" readonly>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Total Interest (KES):</strong></label>
                        <input type="number" class="form-control" id="totalInterest" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label><strong>Date Applied:</strong></label>
                        <input type="date" class="form-control" id="appliedDate" readonly>
                    </div>
                </div>

                <!-- BANK DETAILS SECTION -->
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                            <i class="fa fa-bank"></i> MEMBER BANK DETAILS
                        </h5>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Bank Name:</strong></label>
                        <input type="text" class="form-control" id="bankName" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label><strong>Account Name:</strong></label>
                        <input type="text" class="form-control" id="accountName" readonly>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Bank Account Number:</strong></label>
                        <input type="text" class="form-control" id="bankAccountNo" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label><strong>Branch Name:</strong></label>
                        <input type="text" class="form-control" id="branchName" readonly>
                    </div>
                </div>

                <!-- NEXT OF KIN SECTION -->
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                            <i class="fa fa-users"></i> NEXT OF KIN
                        </h5>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Next of Kin Name:</strong></label>
                        <input type="text" class="form-control" id="nextOfKin" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label><strong>Relation:</strong></label>
                        <input type="text" class="form-control" id="relation" readonly>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Phone Number:</strong></label>
                        <input type="tel" class="form-control" id="nextOfKinPhone" readonly>
                    </div>
                </div>

                <!-- GUARANTOR INFORMATION SECTION -->
                <div class="row mb-4" id="guarantorSection">
                    <div class="col-md-12">
                        <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                            <i class="fa fa-shield"></i> GUARANTOR INFORMATION
                        </h5>
                    </div>
                </div>

                <div id="guarantorDetails">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label><strong>Guarantor Full Name:</strong></label>
                            <input type="text" class="form-control" id="guarantorFullName" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label><strong>Guarantor ID Number:</strong></label>
                            <input type="text" class="form-control" id="guarantorIdNo" readonly>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label><strong>Employer Name:</strong></label>
                            <input type="text" class="form-control" id="guarantorEmployerName" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label><strong>Phone Number:</strong></label>
                            <input type="tel" class="form-control" id="guarantorPhoneNo" readonly>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label><strong>Postal Address:</strong></label>
                            <input type="text" class="form-control" id="guarantorPostalAddress" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label><strong>Physical Address:</strong></label>
                            <input type="text" class="form-control" id="guarantorPhysicalAddress" readonly>
                        </div>
                    </div>
                </div>

                <!-- ASSETS/SECURITY SECTION -->
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                            <i class="fa fa-shield"></i> ASSETS TO BE PLEDGED AS SECURITY
                        </h5>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <div id="assetsTable"></div>
                    </div>
                </div>

                <!-- APPLICATION STATUS SECTION -->
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                            <i class="fa fa-info-circle"></i> APPLICATION STATUS
                        </h5>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Status:</strong></label>
                        <div id="statusBadge"></div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label><strong>Created Date:</strong></label>
                        <input type="datetime-local" class="form-control" id="createdAt" readonly>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <label><strong>Last Updated:</strong></label>
                        <input type="datetime-local" class="form-control" id="updatedAt" readonly>
                    </div>
                </div>

                <!-- ACCEPTANCE AND DECLARATION SECTION -->
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                            <i class="fa fa-file-text"></i> ACCEPTANCE AND DECLARATION OF APPLICANT
                        </h5>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <p style="font-size: 12px; line-height: 1.6; text-align: justify;">
                            I hereby declare that the above particulars are true to the best of my knowledge and belief and that I agree to abide by the conditions of the Society Loaning policy. I further declare that I have understood the terms of the loan. I thereby authorize the necessary deductions to be made from my salary. I fully understand and accept that in case of default, my shares may be used to offset the outstanding loan. Should the monies be insufficient to clear the loans, the item purchased with the loan shall form part of security and Sunbird Tourism SACCO is obliged to take custody thereof including the assets which are pledged as security. All items may be sold to recover expenses.
                        </p>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>Signature of Applicant:</strong></label>
                        <input type="text" class="form-control" id="applicantSignatureName" readonly>
                        <small class="form-text text-muted">Date: <span id="applicantSignatureDate"></span></small>
                        <div id="applicantSignatureImageDiv" style="margin-top: 10px; display: none;">
                            <img id="applicantSignatureImage" style="max-width: 100%; max-height: 150px; border: 1px solid #ddd; padding: 5px; cursor: pointer;" title="Click to resize">
                            <small class="form-text text-muted d-block mt-2">Uploaded Signature</small>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label><strong>Witness Name (on behalf of an employer):</strong></label>
                        <input type="text" class="form-control" id="witnessName" readonly>
                        <small class="form-text text-muted">Date: <span id="witnessSignatureDate"></span></small>
                        <div id="witnessSignatureImageDiv" style="margin-top: 10px; display: none;">
                            <img id="witnessSignatureImage" style="max-width: 100%; max-height: 150px; border: 1px solid #ddd; padding: 5px; cursor: pointer;" title="Click to resize">
                            <small class="form-text text-muted d-block mt-2">Uploaded Signature</small>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label><strong>HR/Finance Manager Name:</strong></label>
                        <input type="text" class="form-control" id="hrFinanceManagerName" readonly>
                        <small class="form-text text-muted">Date: <span id="hrFinanceManagerDate"></span></small>
                        <div id="hrFinanceManagerSignatureImageDiv" style="margin-top: 10px; display: none;">
                            <img id="hrFinanceManagerSignatureImage" style="max-width: 100%; max-height: 150px; border: 1px solid #ddd; padding: 5px; cursor: pointer;" title="Click to resize">
                            <small class="form-text text-muted d-block mt-2">Uploaded Signature</small>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <label><strong>Loan Recommendations:</strong></label>
                        <textarea class="form-control" id="loanRecommendation" rows="4" readonly></textarea>
                    </div>
                </div>

                <!-- LOAN GUARANTOR SECTION -->
                <div class="row mb-4" id="guarantorSection2">
                    <div class="col-md-12">
                        <h5 class="border-bottom pb-2" style="background-color: #e9ecef; padding: 10px;">
                            <i class="fa fa-shield"></i> LOAN GUARANTOR
                        </h5>
                    </div>
                </div>

                <div id="guarantorTableSection">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <table class="table table-bordered">
                                <tbody>
                                    <tr>
                                        <td style="width: 50%;"><strong>Full Name:</strong><br><input type="text" class="form-control" id="guarantorFullNameTable" readonly></td>
                                        <td style="width: 50%;"><strong>Employer Name:</strong><br><input type="text" class="form-control" id="guarantorEmployerNameTable" readonly></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Postal Address:</strong><br><input type="text" class="form-control" id="guarantorPostalAddressTable" readonly></td>
                                        <td><strong>Physical Address:</strong><br><input type="text" class="form-control" id="guarantorPhysicalAddressTable" readonly></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Phone No:</strong><br><input type="text" class="form-control" id="guarantorPhoneNoTable" readonly></td>
                                        <td><strong>ID No:</strong><br><input type="text" class="form-control" id="guarantorIdNoTable" readonly></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <h6 style="background-color: #fff3cd; padding: 10px; margin-bottom: 10px;"><strong>Guarantor's Oath</strong></h6>
                            <p style="font-size: 12px; line-height: 1.6; text-align: justify; background-color: #fffbf0; padding: 10px; border-left: 4px solid #ff9800;">
                                I ........................................................................................ of the above information hereby guarantees that: Mr./Mrs./Miss...................................... of ..................................... shall repay the loan of K............................. (Amount in words) ...................................................... Granted to him/her on the .......... day of ................20...... irrevocably undertake to REPAY to SUNBIRD SACCO LIMITED, the value of the loan on any form of indebtedness and other associated cost of debt recovery/charges on behalf of the above mentioned applicant if he/she fails to repay the loan on or before the due date of ............................... also attest to the fact that I am duly informed and privy to this transaction between SUNBIRD SACCO LIMITED and ....................................................................................... (The Applicant)
                            </p>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label><strong>Guarantor Signature:</strong></label>
                            <input type="text" class="form-control" id="guarantorSignatureName" readonly>
                            <small class="form-text text-muted">Date: <span id="guarantorSignatureDate"></span></small>
                            <div id="guarantorSignatureImageDiv" style="margin-top: 10px; display: none;">
                                <img id="guarantorSignatureImage" style="max-width: 100%; max-height: 150px; border: 1px solid #ddd; padding: 5px; cursor: pointer;" title="Click to resize">
                                <small class="form-text text-muted d-block mt-2">Uploaded Signature</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ACTION BUTTONS -->
                <div class="row mt-4 pt-3 border-top">
                    <div class="col-md-12">
                        <button type="button" class="btn btn-outline-secondary" onclick="window.history.back()">
                            <i class="fa fa-arrow-left"></i> Back
                        </button>
                        <button type="button" class="btn btn-outline-primary" onclick="window.print()">
                            <i class="fa fa-print"></i> Print
                        </button>
                        <button type="button" class="btn btn-outline-success" id="downloadPdfBtn2">
                            <i class="fa fa-file-pdf-o"></i> Download PDF
                        </button>
                        <button type="button" class="btn btn-outline-warning" id="changeStatusBtn" style="display: none;">
                            <i class="fa fa-arrow-right"></i> Submit Application
                        </button>
                    </div>
                </div>

            </form>

        </div>

    </div>

</div>

<!-- Bootstrap core JavaScript -->
<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
<script>
    window.jQuery || document.write('<script src="../../js/vendor/jquery-slim.min.js"><\/script>')
</script>
<script src="../../js/vendor/popper.min.js"></script>
<script src="../../js/bootstrap.min.js"></script>
<script type="text/javascript" src="../../js/jquery-3.2.1.min.js"></script>

<script>
    $(function() {
        loadApplicationData();

        // Download PDF
        $(document).on('click', '#downloadPdfBtn, #downloadPdfBtn2', function() {
            var applicationId = getApplicationId();
            if (applicationId) {
                window.location.href = 'download-loan-application-pdf.php?id=' + applicationId;
            }
        });

        // Change status
        $(document).on('click', '#changeStatusBtn', function() {
            var applicationId = getApplicationId();
            if (applicationId && confirm('Are you sure you want to submit this application?')) {
                $.ajax({
                    url: 'update-loan-application-status.php',
                    type: 'POST',
                    data: {
                        application_id: applicationId,
                        status: 'submitted'
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#error').html('<div class="alert alert-success alert-dismissible fade show" role="alert">Application submitted successfully!<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>');
                            setTimeout(function() {
                                window.location.href = 'individual_loan_applications.php';
                            }, 2000);
                        } else {
                            $('#error').html('<div class="alert alert-danger alert-dismissible fade show" role="alert">' + response.message + '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>');
                        }
                    },
                    error: function() {
                        $('#error').html('<div class="alert alert-danger alert-dismissible fade show" role="alert">Error submitting application<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>');
                    },
                    dataType: 'json'
                });
            }
        });
    });

    function getApplicationId() {
        var urlParams = new URLSearchParams(window.location.search);
        return urlParams.get('id');
    }

    function loadApplicationData() {
        var applicationId = getApplicationId();
        
        if (!applicationId) {
            $('#error').html('<div class="alert alert-danger">Invalid application ID</div>');
            return;
        }

        $.ajax({
            url: 'get-loan-application-data.php',
            type: 'GET',
            data: { id: applicationId },
            success: function(response) {
                if (response.success) {
                    populateForm(response.data);
                } else {
                    $('#error').html('<div class="alert alert-danger">' + response.message + '</div>');
                }
            },
            error: function() {
                $('#error').html('<div class="alert alert-danger">Error loading application data</div>');
            },
            dataType: 'json'
        });
    }

    function populateForm(data) {
        // Personal Information
        $('#appNumber').text(data.application_number || 'N/A');
        $('#fullName').val(data.full_name || '');
        $('#saccoAccountNo').val(data.sacco_account_no || '');
        $('#email').val(data.email || '');
        $('#phoneNo').val(data.phone_no || '');
        $('#occupation').val(data.occupation || '');
        $('#basicSalary').val(data.basic_salary || '');
        $('#placeOfResident').val(data.place_of_resident || '');
        $('#physicalAddress').val(data.physical_address || '');

        // Employer Information
        $('#employerName').val(data.employer_name || '');
        $('#employmentNo').val(data.employment_no || '');
        $('#employerAddress').val(data.employer_address || '');

        // Loan Information
        $('#loanType').val(data.loan_name || 'N/A');
        $('#loanAmountApplied').val(data.loan_amount_applied || '');
        $('#repaymentPeriodMonths').val(data.repayment_period_months || '');
        $('#monthlyRepaymentAmount').val(data.monthly_repayment_amount || '');
        $('#totalRepaymentAmount').val(data.total_repayment_amount || '');
        $('#totalInterest').val(data.total_interest || '');
        $('#appliedDate').val(data.applied_date || '');

        // Bank Details
        $('#bankName').val(data.bank_name || '');
        $('#accountName').val(data.account_name || '');
        $('#bankAccountNo').val(data.bank_account_no || '');
        $('#branchName').val(data.branch_name || '');

        // Next of Kin
        $('#nextOfKin').val(data.next_of_kin || '');
        $('#relation').val(data.relation || '');
        $('#nextOfKinPhone').val(data.next_of_kin_phone || '');

        // Guarantor Information (Original section)
        $('#guarantorFullName').val(data.guarantor_full_name || '');
        $('#guarantorIdNo').val(data.guarantor_id_no || '');
        $('#guarantorEmployerName').val(data.guarantor_employer_name || '');
        $('#guarantorPhoneNo').val(data.guarantor_phone_no || '');
        $('#guarantorPostalAddress').val(data.guarantor_postal_address || '');
        $('#guarantorPhysicalAddress').val(data.guarantor_physical_address || '');

        // Guarantor Information (Table section)
        $('#guarantorFullNameTable').val(data.guarantor_full_name || '');
        $('#guarantorIdNoTable').val(data.guarantor_id_no || '');
        $('#guarantorEmployerNameTable').val(data.guarantor_employer_name || '');
        $('#guarantorPhoneNoTable').val(data.guarantor_phone_no || '');
        $('#guarantorPostalAddressTable').val(data.guarantor_postal_address || '');
        $('#guarantorPhysicalAddressTable').val(data.guarantor_physical_address || '');

        // Assets Description - Display as table
        if (data.assets_description) {
            var assetsHtml = '<table class="table table-bordered" style="font-size: 13px;">';
            assetsHtml += '<thead style="background-color: #f5f5f5;">';
            assetsHtml += '<tr>';
            assetsHtml += '<th style="width: 8%; text-align: center;">No</th>';
            assetsHtml += '<th style="width: 52%; text-align: center;">Name of Item; Serial No.; Make; (Other Necessary Description)</th>';
            assetsHtml += '<th style="width: 20%; text-align: center;">Value in MK</th>';
            assetsHtml += '</tr>';
            assetsHtml += '</thead><tbody>';
            
            try {
                // Try to parse as JSON first
                var assetsData = JSON.parse(data.assets_description);
                if (Array.isArray(assetsData)) {
                    // If array, add each asset as a row
                    assetsData.forEach(function(asset, index) {
                        var assetName = '';
                        var assetValue = '';
                        if (typeof asset === 'object') {
                            assetName = (asset.name || asset.description || '') + 
                                       (asset.serial_no ? '; S/N: ' + asset.serial_no : '') +
                                       (asset.make ? '; Make: ' + asset.make : '') +
                                       (asset.other_description ? '; ' + asset.other_description : '');
                            assetValue = asset.value || asset.amount || '';
                        } else {
                            assetName = asset;
                            assetValue = '';
                        }
                        assetsHtml += '<tr>';
                        assetsHtml += '<td style="text-align: center;">' + (index + 1) + '</td>';
                        assetsHtml += '<td>' + assetName + '</td>';
                        assetsHtml += '<td style="text-align: right;">' + assetValue + '</td>';
                        assetsHtml += '</tr>';
                    });
                } else if (typeof assetsData === 'object') {
                    // If object, iterate through properties
                    var index = 1;
                    Object.keys(assetsData).forEach(function(key) {
                        var value = assetsData[key];
                        assetsHtml += '<tr>';
                        assetsHtml += '<td style="text-align: center;">' + index + '</td>';
                        assetsHtml += '<td>' + (typeof value === 'object' ? JSON.stringify(value) : value) + '</td>';
                        assetsHtml += '<td style="text-align: right;"></td>';
                        assetsHtml += '</tr>';
                        index++;
                    });
                } else {
                    // If plain string, add single row
                    assetsHtml += '<tr>';
                    assetsHtml += '<td style="text-align: center;">1</td>';
                    assetsHtml += '<td>' + data.assets_description + '</td>';
                    assetsHtml += '<td style="text-align: right;"></td>';
                    assetsHtml += '</tr>';
                }
            } catch(e) {
                // If not JSON, display as plain text in first row
                assetsHtml += '<tr>';
                assetsHtml += '<td style="text-align: center;">1</td>';
                assetsHtml += '<td>' + data.assets_description + '</td>';
                assetsHtml += '<td style="text-align: right;"></td>';
                assetsHtml += '</tr>';
            }
            
            assetsHtml += '</tbody></table>';
            $('#assetsTable').html(assetsHtml);
        } else {
            // Display empty table if no assets
            var emptyHtml = '<table class="table table-bordered" style="font-size: 13px;">';
            emptyHtml += '<thead style="background-color: #f5f5f5;">';
            emptyHtml += '<tr>';
            emptyHtml += '<th style="width: 8%; text-align: center;">No</th>';
            emptyHtml += '<th style="width: 52%; text-align: center;">Name of Item; Serial No.; Make; (Other Necessary Description)</th>';
            emptyHtml += '<th style="width: 20%; text-align: center;">Value in MK</th>';
            emptyHtml += '</tr>';
            emptyHtml += '</thead><tbody>';
            for (var i = 1; i <= 4; i++) {
                emptyHtml += '<tr><td style="text-align: center;">' + i + '</td><td></td><td style="text-align: right;"></td></tr>';
            }
            emptyHtml += '</tbody></table>';
            $('#assetsTable').html(emptyHtml);
        }

        // Acceptance and Declaration
        $('#applicantSignatureName').val(data.full_name || '');
        if (data.applicant_signature_date) {
            $('#applicantSignatureDate').text(new Date(data.applicant_signature_date).toLocaleDateString());
        }
        
        $('#witnessName').val(data.witness_name || '');
        if (data.witness_signature_date) {
            $('#witnessSignatureDate').text(new Date(data.witness_signature_date).toLocaleDateString());
        }
        
        $('#hrFinanceManagerName').val(data.hr_finance_manager_name || '');
        if (data.hr_finance_manager_date) {
            $('#hrFinanceManagerDate').text(new Date(data.hr_finance_manager_date).toLocaleDateString());
        }
        
        $('#loanRecommendation').val(data.loan_recommendation || '');
        
        $('#guarantorSignatureName').val(data.guarantor_full_name || '');
        if (data.guarantor_signature_date) {
            $('#guarantorSignatureDate').text(new Date(data.guarantor_signature_date).toLocaleDateString());
        }

        // Status
        if (data.status === 'draft') {
            $('#statusBadge').html('<span class="badge badge-warning" style="font-size: 14px; padding: 8px 12px;">DRAFT - Not Submitted</span>');
            $('#changeStatusBtn').show();
        } else {
            $('#statusBadge').html('<span class="badge badge-success" style="font-size: 14px; padding: 8px 12px;">SUBMITTED</span>');
        }

        // Dates
        if (data.created_at) {
            $('#createdAt').val(data.created_at.replace(' ', 'T'));
        }
        if (data.updated_at) {
            $('#updatedAt').val(data.updated_at.replace(' ', 'T'));
        }

        // Hide guarantor section if no guarantor info
        if (!data.guarantor_full_name) {
            $('#guarantorSection').hide();
            $('#guarantorDetails').hide();
            $('#guarantorSection2').hide();
            $('#guarantorTableSection').hide();
        }

        // Display signature images
        if (data.applicant_signature_file) {
            $('#applicantSignatureImage').attr('src', '../../../' + data.applicant_signature_file);
            $('#applicantSignatureImageDiv').show();
        }

        if (data.witness_signature_file) {
            $('#witnessSignatureImage').attr('src', '../../../' + data.witness_signature_file);
            $('#witnessSignatureImageDiv').show();
        }

        if (data.hr_finance_manager_signature_file) {
            $('#hrFinanceManagerSignatureImage').attr('src', '../../../' + data.hr_finance_manager_signature_file);
            $('#hrFinanceManagerSignatureImageDiv').show();
        }

        if (data.guarantor_signature_file) {
            $('#guarantorSignatureImage').attr('src', '../../uploads/' + data.guarantor_signature_file);
            $('#guarantorSignatureImageDiv').show();
        }
    }

    // Image resize modal functionality
    $(document).on('click', 'img[id$="SignatureImage"]', function() {
        var $img = $(this);
        var modalHtml = '<div id="imageResizeModal" class="modal" style="display: block; background-color: rgba(0,0,0,0.8); z-index: 9999; position: fixed; top: 0; left: 0; width: 100%; height: 100%;\">';
        modalHtml += '<div style="position: relative; margin: auto; top: 50%; transform: translateY(-50%); max-width: 90%; max-height: 90%;\">';
        modalHtml += '<img src="' + $img.attr('src') + '" style="max-width: 100%; max-height: 100%; display: block; margin: auto;">';
        modalHtml += '<div style="text-align: center; margin-top: 20px; color: white;">';
        modalHtml += '<p>Click anywhere outside to close</p>';
        modalHtml += '</div>';
        modalHtml += '</div>';
        modalHtml += '</div>';
        $('body').append(modalHtml);

        $(document).on('click', '#imageResizeModal', function(e) {
            if (e.target === this) {
                $('#imageResizeModal').remove();
                $(document).off('click', '#imageResizeModal');
            }
        });
    });

</script>

</body>

</html>
