<?php
session_start();
include_once('../../config/config.php');

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

if (!isset($_POST['application_id']) || !isset($_POST['status'])) {
    echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
    exit;
}

$application_id = intval($_POST['application_id']);
$status = $_POST['status'];

// Validate status
if (!in_array($status, ['draft', 'submitted'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid status']);
    exit;
}

try {
    // Check if application exists
    $checkStmt = $db->prepare("SELECT id FROM individual_loan_applications WHERE id = :id");
    $checkStmt->execute([':id' => $application_id]);
    
    if ($checkStmt->rowCount() == 0) {
        echo json_encode(['success' => false, 'message' => 'Application not found']);
        exit;
    }
    
    // Update status
    $updateStmt = $db->prepare("UPDATE individual_loan_applications SET status = :status, updated_at = NOW() WHERE id = :id");
    $result = $updateStmt->execute([
        ':status' => $status,
        ':id' => $application_id
    ]);
    
    if ($result) {
        echo json_encode(['success' => true, 'message' => 'Status updated successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update status']);
    }
    
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
