<?php include_once('header.php'); ?>
<?php
$action = '';
$testimonial_id = '';
if (isset($_GET['action']) && isset($_GET['testimonial_id'])) {
    $action = $_GET['action'];
    $testimonial_id = $_GET['testimonial_id'];
}
?>
<style type="text/css">
    .error {
        border-color: #ecbeb6;
        color: #b55351;
        text-transform: capitalize;
        text-align: left !important;
    }

    #error {
        width: 100%;
    }

    .alert {
        width: 100%;
        text-align: left;
    }
</style>
<div class="container mt-3">
    <div class="card-deck mb-3 text-center">
        <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 mt-3 border-bottom" style="width: 100%;">
            <h1 class="h2">Testimonials Management</h1>
            <div class="btn-toolbar mb-2 mb-md-0">
                <div class="btn-group mr-2">
                    <a class="btn btn-sm btn-outline-secondary" href="testimonials.php">All Testimonials</a>
                </div>
            </div>
        </div>

        <div id="error"></div>

        <div class="row text-left">
            <div id="live_data" class="col-md-8"></div>
            <div class="col-md-4">
                <?php if($action == ''){ ?>
                <h4 style="text-align: left;">Add Testimonial</h4><br>
                <div id="err"></div>
                <form class="needs-validation" style="text-align: left;" id="add-testimonial" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="customerName" style="text-align:left; float:left">Customer Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="customer_name" required>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="customerRole" style="text-align:left; float:left">Customer Role <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="customer_role" placeholder="e.g., Business Owner, Teacher, Engineer" required>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="customerImage" style="text-align:left; float:left">Customer Image (300x300) <span class="text-danger">*</span></label>
                            <input type="file" class="form-control" id="file" name="customer_image" required>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="testimonialText" style="text-align:left; float:left">Testimonial Text <span class="text-danger">*</span></label>
                            <textarea class="form-control no-textboxio" name="testimonial_text" rows="6" placeholder="Enter the customer's testimonial..." required></textarea>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="rating" style="text-align:left; float:left">Rating (1-5 stars) <span class="text-danger">*</span></label>
                            <select class="form-control" name="rating" required>
                                <option value="">Select Rating</option>
                                <option value="5">⭐⭐⭐⭐⭐ - Excellent (5 stars)</option>
                                <option value="4">⭐⭐⭐⭐ - Very Good (4 stars)</option>
                                <option value="3">⭐⭐⭐ - Good (3 stars)</option>
                                <option value="2">⭐⭐ - Fair (2 stars)</option>
                                <option value="1">⭐ - Poor (1 star)</option>
                            </select>
                        </div>
                        <div class="col-md-8 mb-3">
                            <input type="hidden" name="action" value="create">
                            <button class="btn btn-primary btn-md form-control" type="submit" name="add_testimonial" id="submit_btn" style="float: left; margin-right: 5px;">
                                Save Testimonial
                            </button>
                        </div>
                    </div>
                </form>
                <?php } else if($action == 'update'){ ?>
                <h4 style="text-align: left;">Update Testimonial <a href="testimonials.php" class="btn btn-primary btn-sm" style="float:right;">Add Testimonial</a></h4><br>
                <?php 
                    $testimonial = $con->getRows('testimonials', array('where' => 'testimonial_id="' . $testimonial_id . '"', 'return_type' => 'single'));
                    if(!empty($testimonial)){
                ?>
                <div id="err"></div>
                <form class="needs-validation" style="text-align: left;" id="add-testimonial" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="customerName" style="text-align:left; float:left">Customer Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="customer_name" value="<?php echo htmlspecialchars($testimonial['customer_name']); ?>" required>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="customerRole" style="text-align:left; float:left">Customer Role <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="customer_role" value="<?php echo htmlspecialchars($testimonial['customer_role']); ?>" required>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="customerImage" style="text-align:left; float:left">Update Image (300x300)</label>
                            <input type="file" class="form-control" id="file" name="customer_image">
                            <input type="hidden" name="current_image" value="<?php echo htmlspecialchars($testimonial['customer_image']); ?>">
                            <?php if(!empty($testimonial['customer_image'])): ?>
                            <small class="form-text text-muted">Current image: <?php echo htmlspecialchars($testimonial['customer_image']); ?></small>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="testimonialText" style="text-align:left; float:left">Testimonial Text <span class="text-danger">*</span></label>
                            <textarea class="form-control no-textboxio" name="testimonial_text" rows="6" required><?php echo htmlspecialchars($testimonial['testimonial_text']); ?></textarea>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="rating" style="text-align:left; float:left">Rating (1-5 stars) <span class="text-danger">*</span></label>
                            <select class="form-control" name="rating" required>
                                <option value="">Select Rating</option>
                                <option value="5" <?php echo ($testimonial['rating'] == 5) ? 'selected' : ''; ?>>⭐⭐⭐⭐⭐ - Excellent (5 stars)</option>
                                <option value="4" <?php echo ($testimonial['rating'] == 4) ? 'selected' : ''; ?>>⭐⭐⭐⭐ - Very Good (4 stars)</option>
                                <option value="3" <?php echo ($testimonial['rating'] == 3) ? 'selected' : ''; ?>>⭐⭐⭐ - Good (3 stars)</option>
                                <option value="2" <?php echo ($testimonial['rating'] == 2) ? 'selected' : ''; ?>>⭐⭐ - Fair (2 stars)</option>
                                <option value="1" <?php echo ($testimonial['rating'] == 1) ? 'selected' : ''; ?>>⭐ - Poor (1 star)</option>
                            </select>
                        </div>
                        <div class="col-md-8 mb-3">
                            <input type="hidden" name="action" value="update">
                            <input type="hidden" name="testimonial_id" value="<?php echo htmlspecialchars($testimonial['testimonial_id']); ?>">
                            <button class="btn btn-primary btn-md form-control" type="submit" name="update_testimonial" id="submit_btn" style="float: left; margin-right: 5px;">
                                Update Testimonial
                            </button>
                        </div>
                    </div>
                </form>

                <?php } } ?>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap core JavaScript -->
<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
<script>
    window.jQuery || document.write('<script src="../../js/vendor/jquery-slim.min.js"><\/script>')
</script>
<script src="../../js/vendor/popper.min.js"></script>
<script src="../../js/bootstrap.min.js"></script>
<script src="../../js/vendor/holder.min.js"></script>
<script type="text/javascript" src="../../js/jquery-3.2.1.min.js"></script>
<script type="text/javascript" src="../../js/validation.min.js"></script>
<script src="../../js/tables/jquery.dataTables.js"></script>
<script src="../../js/tables/dataTables.bootstrap4.js"></script>

<script>
    function fetchData() {
        $.ajax({
            url: "select-testimonials.php",
            method: "GET",
            success: function(data) {
                $('#live_data').html(data);
            }
        });
    }

    $(document).ready(function() {
        // Load testimonials on page load
        $.ajax({
            url: "select-testimonials.php",
            method: "GET",
            success: function(data) {
                $('#live_data').html(data);
            }
        });

        // Form validation
        $("#add-testimonial").validate({
            rules: {
                customer_name: { required: true },
                customer_role: { required: true },
                customer_image: { required: function() { 
                    return $("input[name='action']").val() === 'create';
                }},
                testimonial_text: { required: true },
                rating: { required: true }
            },
            messages: {
                customer_name: "Please enter customer name",
                customer_role: "Please enter customer role",
                customer_image: "Please select customer image",
                testimonial_text: "Please enter testimonial text",
                rating: "Please select a rating"
            },
            submitHandler: saveTestimonial
        });

        function saveTestimonial() {
            var formData = new FormData($("#add-testimonial")[0]);

            $.ajax({
                type: 'POST',
                url: 'manage-testimonials.php',
                data: formData,
                beforeSend: function() {
                    $("#err").fadeOut();
                    $("#submit_btn").html('<i class="fa fa-spin fa-spinner"></i> Saving...');
                },
                success: function(response) {
                    if (response == 1) {
                        $("#err").fadeIn(1000, function() {
                            $("#err").html('<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span> Testimonial has been saved successfully.</div>');
                        });
                        $("#add-testimonial")[0].reset();
                        $("#err").delay(6000).fadeOut(function() {});
                        $("#submit_btn").html('Save Testimonial');
                        fetchData();
                    } else if (response == 2) {
                        $("#err").fadeIn(1000, function() {
                            $("#err").html('<div class="alert alert-warning"><button type="button" class="close" data-dismiss="alert">×</button>There was an error saving the testimonial. Please try again!</div>');
                            $("#submit_btn").html('Save Testimonial');
                        });
                        $("#err").delay(6000).fadeOut(function() {});
                    } else if (response == 3) {
                        $("#err").fadeIn(1000, function() {
                            $("#err").html('<div class="alert alert-warning"><button type="button" class="close" data-dismiss="alert">×</button>The uploaded image is not valid. It should be JPEG, JPG, or PNG.</div>');
                            $("#submit_btn").html('Save Testimonial');
                        });
                        $("#err").delay(6000).fadeOut(function() {});
                    }
                },
                error: function() {
                    $("#err").fadeIn(1000, function() {
                        $("#err").html('<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert">×</button>An error occurred. Please try again!</div>');
                        $("#submit_btn").html('Save Testimonial');
                    });
                    $("#err").delay(6000).fadeOut(function() {});
                },
                contentType: false,
                processData: false,
                cache: false
            });
            return false;
        }
    });

    // Delete testimonial
    $(document).on('click', '.btn_delete', function() {
        var id = $(this).data("id3");
        if (confirm("Are you sure you want to remove this testimonial?")) {
            $.ajax({
                url: "manage-testimonials.php",
                method: "POST",
                data: {
                    testimonial_id: id,
                    action: "delete"
                },
                dataType: "text",
                success: function(data) {
                    if (data == 1) {
                        $("#error").fadeIn(1000, function() {
                            $("#error").html('<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span>&nbsp; Testimonial has been deleted!</div>');
                        });
                        $("#error").delay(6000).fadeOut(function() {});
                    } else {
                        $("#error").fadeIn(1000, function() {
                            $("#error").html('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">×</button><i class="icon wb-warning" aria-hidden="true"></i> There was an error deleting the testimonial, please try again.</div>');
                        });
                        $("#error").delay(6000).fadeOut(function() {});
                    }
                    fetchData();
                }
            });
        }
    });
</script>
</body>

</html>
