<?php
/**** Display testimonials in table format *****/
session_start();
include_once('../../config/config.php');
$user_id = $_SESSION['user_id'];

//select statement
$statement = "SELECT * FROM testimonials ORDER BY testimonial_id DESC";

try {
    $sql = $db->query($statement);
    if ($sql && $sql->rowCount() > 0) {
?>

        <table id="order-listing" class="table table-striped table-bordered table-sm">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Customer Name</th>
                    <th>Role</th>
                    <th>Testimonial</th>
                    <th>Rating</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <?php
            echo "<tbody>";
            $i = 0;
            while ($row = $sql->fetch()) {
                $i++;
                $testimonial = strlen($row['testimonial_text']) > 60 ? substr($row['testimonial_text'], 0, 60) . '...' : $row['testimonial_text'];
                $rating_stars = str_repeat('⭐', $row['rating']);
                echo "
                <tr>
                    <td>" . $i . "</td>
                    <td>" . htmlspecialchars($row['customer_name']) . "</td>
                    <td>" . htmlspecialchars($row['customer_role']) . "</td>
                    <td>" . htmlspecialchars($testimonial) . "</td>
                    <td>" . $rating_stars . "</td>
                    <td>" . date('M d, Y', strtotime($row['date_created'])) . "</td>
                    <td>";
            ?>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group mr-2">
                            <a href="testimonials.php?action=update&testimonial_id=<?php echo $row["testimonial_id"]; ?>" class="btn btn-sm btn-outline-primary">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                            <button class="btn btn-sm btn-outline-danger btn_delete" data-id3="<?php echo $row["testimonial_id"]; ?>">
                                <i class="fa fa-trash"></i> Delete
                            </button>
                        </div>
                    </div>
            <?php
                echo " </td>
                </tr>";
            }
            echo "</tbody>";
        } else {
            echo "<tr><td colspan='7' class='text-center'>No testimonials found</td></tr>";
        }
        ?>
        </table>

    <?php
} catch (PDOException $e) {
    echo "<div class='alert alert-danger'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}
?>

<script>
    (function($) {
        'use strict';
        $(function() {
            if ($.fn.DataTable.isDataTable('#order-listing')) {
                $('#order-listing').DataTable().destroy();
            }
            $('#order-listing').DataTable({
                "aLengthMenu": [
                    [5, 10, 15, -1],
                    [5, 10, 15, "All"]
                ],
                "iDisplayLength": 10
            });
        });
    })(jQuery);
</script>
