<?php

/**** this section displays savings products details*****/
session_start();
include_once('../../config/config.php');
$user_id = $_SESSION['user_id'];

//select statement
$statement = "SELECT * FROM savings_products ORDER BY product_id DESC";

try {
    $sql = $db->query($statement);
    if ($sql && $sql->rowCount() > 0) {

?>

        <table id="order-listing" class="table table-striped table-bordered table-sm">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Product Title</th>
                    <th>Description</th>
                    <th>Created Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <?php
            echo "<tbody>";
            $i = 0;
            while ($row = $sql->fetch()) {
                $i++;
                $desc = strlen($row['description']) > 80 ? substr($row['description'], 0, 80) . '...' : $row['description'];
                echo "
                <tr>
                    <td>" . $i . "</td>
                    <td>" . htmlspecialchars($row['title']) . "</td>
                    <td>" . htmlspecialchars($desc) . "</td>
                    <td>" . date('M d, Y', strtotime($row['date'])) . "</td>
                    <td>";
            ?>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group mr-2">
                            <a href="edit-savings-product.php?id=<?php echo $row["product_id"]; ?>" class="btn btn-sm btn-outline-primary">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                            <button class="btn btn-sm btn-outline-danger btn_delete" data-id3="<?php echo $row["product_id"]; ?>">
                                <i class="fa fa-trash"></i> Delete
                            </button>
                        </div>
                    </div>
            <?php
                echo " </td>
                </tr>";
            }
            echo "</tbody>";
        } else {
            echo "<tr><td colspan='5' class='text-center'>No savings products found</td></tr>";
        }
        ?>
        </table>

    <?php
} catch (PDOException $e) {
    echo "<div class='alert alert-danger'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}
    ?>

<script>
    (function($) {
        'use strict';
        $(function() {
            if ($.fn.DataTable.isDataTable('#order-listing')) {
                $('#order-listing').DataTable().destroy();
            }
            $('#order-listing').DataTable({
                "aLengthMenu": [
                    [5, 10, 15, -1],
                    [5, 10, 15, "All"]
                ],
                "iDisplayLength": 10
            });
        });
    })(jQuery);
</script>

