<?php

/**** this section displays membership applications details*****/
session_start();
include_once('../../config/config.php');
$user_id = $_SESSION['user_id'];

//select statement
$statement = "SELECT 
    ma.id,
    ma.application_number,
    ma.full_name,
    ma.email,
    ma.phone_number,
    ma.account_type,
    ma.application_status,
    ma.created_at
FROM membership_applications ma
ORDER BY ma.created_at DESC";

try {
    $sql = $db->query($statement);
    if ($sql && $sql->rowCount() > 0) {

?>

        <table id="order-listing" class="table table-striped table-bordered table-sm">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Full Name</th>
                    <th>Email</th>
                    <th>Phone Number</th>
                    <th>Account Type</th>
                    <th>Status</th>
                    <th>Date Applied</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <?php
            echo "<tbody>";
            $i = 0;
            while ($row = $sql->fetch()) {
                $i++;
                
                // Determine status badge
                $statusClass = 'badge-secondary';
                $statusText = ucfirst($row['application_status']);
                
                switch($row['application_status']) {
                    case 'pending':
                        $statusClass = 'badge-warning';
                        $statusText = 'Pending';
                        break;
                    case 'approved':
                        $statusClass = 'badge-success';
                        $statusText = 'Approved';
                        break;
                    case 'rejected':
                        $statusClass = 'badge-danger';
                        $statusText = 'Rejected';
                        break;
                    case 'withdrawn':
                        $statusClass = 'badge-secondary';
                        $statusText = 'Withdrawn';
                        break;
                }
                
                $statusBadge = '<span class="badge ' . $statusClass . '">' . $statusText . '</span>';
                
                echo "
                <tr>
                    <td>" . $i . "</td>
                    <td>" . htmlspecialchars($row['full_name']) . "</td>
                    <td>" . htmlspecialchars($row['email']) . "</td>
                    <td>" . htmlspecialchars($row['phone_number']) . "</td>
                    <td>" . ucfirst(str_replace('_', ' ', $row['account_type'])) . "</td>
                    <td>" . $statusBadge . "</td>
                    <td>" . date('M d, Y', strtotime($row['created_at'])) . "</td>
                    <td>";
            ?>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group mr-2">
                            <a href="view-membership-application.php?id=<?php echo $row["id"]; ?>" class="btn btn-sm btn-outline-info">
                                <i class="fa fa-eye"></i> View
                            </a>
                            <button class="btn btn-sm btn-outline-primary download-pdf-btn" data-id="<?php echo $row["id"]; ?>">
                                <i class="fa fa-print"></i> Print
                            </button>
                        </div>
                    </div>
            <?php
                echo " </td>
                </tr>";
            }
            echo "</tbody>";
        } else {
            echo "<tr><td colspan='9' class='text-center'>No membership applications found</td></tr>";
        }
        ?>
        </table>

    <?php
} catch (PDOException $e) {
    echo "<div class='alert alert-danger'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}
    ?>

<script>
    (function($) {
        'use strict';
        $(function() {
            if ($.fn.DataTable.isDataTable('#order-listing')) {
                $('#order-listing').DataTable().destroy();
            }
            $('#order-listing').DataTable({
                "aLengthMenu": [
                    [5, 10, 15, -1],
                    [5, 10, 15, "All"]
                ],
                "iDisplayLength": 10
            });
        });
    })(jQuery);
</script>
