<?php
session_start();
include_once('../../config/class.php');
$con = new DB;
$type = '';

if (isset($_GET['type'])) {
    $type = $_GET['type'];
}
?>

<table id="order-listing" class="table table-striped table-bordered table-sm">
    <thead>
        <tr>
            <th>Image</th>
            <th> Name</th>
            <th>Title</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $members = $con->getRows('leadership', array('where' => 'type="' . $type . '"', 'order_by' => 'name'));
        if (!empty($members)) {
            $i = 0;
            foreach ($members as $member) {
                $i++; ?>
                <tr>
                    <td><img src="../../../assets/uploads/leadership/<?= $member['image'] ?>" width="110" height="135"> </td>
                    <td><?= $member['name'] ?></td>
                    <td><?= $member['title'] ?></td>
                    <td>
                        <div class="btn-toolbar mb-2 mb-md-0">
                            <div class="btn-group mr-2">
                                <a href="?member_id=<?=$member["leader_id"]?>&action=update" class="btn btn-sm btn-outline-primary"><i class="icon icon-edit"></i> Update</a>
                                <button class="btn btn-sm btn-outline-danger btn_delete" name="delete_btn" data-id3="<?php echo $member["leader_id"]; ?>"><i class="icon icon-trash"></i> Delete</button>
                            </div>

                        </div>
                    </td>
                </tr>
        <?php        }
        }
        ?>
    </tbody>
</table>





<script>
    (function($) {
        'use strict';
        $(function() {
            $('#order-listing').DataTable({
                "aLengthMenu": [
                    [5, 10, 15, -1],
                    [5, 10, 15, "All"]
                ],
                "iDisplayLength": 10
            });
        });
    })(jQuery);
</script>