<?php

/**** this section displays loan types details*****/
session_start();
include_once('../../config/config.php');
$user_id = $_SESSION['user_id'];

//select statement
$statement = "SELECT * FROM loan_types ORDER BY id ASC";

try {
    $sql = $db->query($statement);
    if ($sql && $sql->rowCount() > 0) {

?>

        <table id="order-listing" class="table table-striped table-bordered table-sm">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Loan Type</th>
                    <th>Monthly Interest Rate (%)</th>
                    <th>Processing Fee (%)</th>
                    <th>Insurance Fee (% Yearly)</th>
                    <th>Created Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <?php
            echo "<tbody>";
            $i = 0;
            while ($row = $sql->fetch()) {
                $i++;
                echo "
                <tr>
                    <td>" . $i . "</td>
                    <td>" . htmlspecialchars($row['loan_name']) . "</td>
                    <td>" . number_format($row['interest_rate_monthly'], 2) . "%</td>
                    <td>" . number_format($row['processing_fee'], 2) . "%</td>
                    <td>" . number_format($row['insurance_fee_yearly'], 2) . "%</td>
                    <td>" . date('M d, Y', strtotime($row['created_at'])) . "</td>
                    <td>";
            ?>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group mr-2">
                            <button type="button" class="btn btn-sm btn-outline-primary edit-btn" 
                                data-toggle="modal" 
                                data-target="#editModal"
                                data-id="<?php echo $row["id"]; ?>"
                                data-loan-name="<?php echo htmlspecialchars($row['loan_name']); ?>"
                                data-loan-description="<?php echo htmlspecialchars($row['loan_description']); ?>"
                                data-interest-rate="<?php echo $row['interest_rate_monthly']; ?>"
                                data-processing-fee="<?php echo $row['processing_fee']; ?>"
                                data-insurance-fee="<?php echo $row['insurance_fee_yearly']; ?>">
                                <i class="fa fa-edit"></i> Edit
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-danger delete-btn" data-id="<?php echo $row["id"]; ?>">
                                <i class="fa fa-trash"></i> Delete
                            </button>
                        </div>
                    </div>
            <?php
                echo " </td>
                </tr>";
            }
            echo "</tbody>";
        } else {
            echo "<tr><td colspan='7' class='text-center'>No loan types found</td></tr>";
        }
        ?>
        </table>

    <?php
} catch (PDOException $e) {
    echo "<div class='alert alert-danger'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}
    ?>

<script>
    (function($) {
        'use strict';
        $(function() {
            if ($.fn.DataTable.isDataTable('#order-listing')) {
                $('#order-listing').DataTable().destroy();
            }
            $('#order-listing').DataTable({
                "aLengthMenu": [
                    [5, 10, 15, -1],
                    [5, 10, 15, "All"]
                ],
                "iDisplayLength": 10
            });
        });
    })(jQuery);
</script>
