<?php

/**** this section displays loan applications details*****/
session_start();
include_once('../../config/config.php');
$user_id = $_SESSION['user_id'];

//select statement
$statement = "SELECT 
    ila.id,
    ila.application_number,
    ila.full_name,
    ila.email,
    ila.phone_no,
    ila.loan_amount_applied,
    ila.status,
    ila.applied_date,
    lt.loan_name
FROM individual_loan_applications ila
LEFT JOIN loan_types lt ON ila.loan_type_id = lt.id
ORDER BY ila.applied_date DESC";

try {
    $sql = $db->query($statement);
    if ($sql && $sql->rowCount() > 0) {

?>

        <table id="order-listing" class="table table-striped table-bordered table-sm">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Application No.</th>
                    <th>Applicant Name</th>
                    <th>Email</th>
                    <th>Loan Type</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Date Applied</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <?php
            echo "<tbody>";
            $i = 0;
            while ($row = $sql->fetch()) {
                $i++;
                $statusBadge = ($row['status'] == 'draft') 
                    ? '<span class="badge badge-warning">Draft</span>' 
                    : '<span class="badge badge-success">Submitted</span>';
                
                echo "
                <tr>
                    <td>" . $i . "</td>
                    <td>" . htmlspecialchars($row['application_number']) . "</td>
                    <td>" . htmlspecialchars($row['full_name']) . "</td>
                    <td>" . htmlspecialchars($row['email']) . "</td>
                    <td>" . htmlspecialchars($row['loan_name'] ?? 'N/A') . "</td>
                    <td>KES " . number_format($row['loan_amount_applied'], 2) . "</td>
                    <td>" . $statusBadge . "</td>
                    <td>" . date('M d, Y', strtotime($row['applied_date'])) . "</td>
                    <td>";
            ?>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group mr-2">
                            <a href="view-loan-application-form.php?id=<?php echo $row["id"]; ?>" class="btn btn-sm btn-outline-info">
                                <i class="fa fa-eye"></i> View Form
                            </a>
                            <button class="btn btn-sm btn-outline-primary download-pdf-btn" data-id="<?php echo $row["id"]; ?>">
                                <i class="fa fa-file-pdf-o"></i> PDF
                            </button>
                            <?php if ($row['status'] == 'draft') { ?>
                                <button class="btn btn-sm btn-outline-warning change-status-btn" data-id="<?php echo $row["id"]; ?>" data-status="<?php echo $row['status']; ?>">
                                    <i class="fa fa-arrow-right"></i> Submit
                                </button>
                            <?php } ?>
                        </div>
                    </div>
            <?php
                echo " </td>
                </tr>";
            }
            echo "</tbody>";
        } else {
            echo "<tr><td colspan='9' class='text-center'>No loan applications found</td></tr>";
        }
        ?>
        </table>

    <?php
} catch (PDOException $e) {
    echo "<div class='alert alert-danger'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}
    ?>

<script>
    (function($) {
        'use strict';
        $(function() {
            if ($.fn.DataTable.isDataTable('#order-listing')) {
                $('#order-listing').DataTable().destroy();
            }
            $('#order-listing').DataTable({
                "aLengthMenu": [
                    [5, 10, 15, -1],
                    [5, 10, 15, "All"]
                ],
                "iDisplayLength": 10
            });
        });
    })(jQuery);
</script>
