<?php include_once('header.php'); ?>

<div class="container">
    <div class="card-deck mb-3 text-center">
        <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mt-3 mb-3 border-bottom" style="width: 100%;">
            <h1 class="h2">Membership Applications</h1>
            <div class="btn-toolbar mb-2 mb-md-0">
                <div class="btn-group mr-2">
                    <a class="btn btn-sm btn-outline-secondary" href="dashboard.php">Dashboard</a>
                </div>
            </div>
        </div>

        <div id="error"></div>

        <!-- Membership Applications Table -->
        <div style="width: 100%">
            <div class="table-responsive">
                <div id="live_data" style="width: 100%; text-align: left;"></div>
            </div>
        </div>

    </div>

</div>

<!-- Bootstrap core JavaScript -->
<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
<script>
    window.jQuery || document.write('<script src="../../js/vendor/jquery-slim.min.js"><\/script>')
</script>
<script src="../../js/vendor/popper.min.js"></script>
<script src="../../js/bootstrap.min.js"></script>
<script src="../../js/vendor/holder.min.js"></script>
<script type="text/javascript" src="../../js/jquery-3.2.1.min.js"></script>
<script type="text/javascript" src="../../js/validation.min.js"></script>
<script src="../../js/tables/jquery.dataTables.js"></script>
<script src="../../js/tables/dataTables.bootstrap4.js"></script>

<script>
    $(function() {
        loadApplications();
    });

    function loadApplications() {
        $.ajax({
            url: 'select-membership-applications.php',
            type: 'GET',
            success: function(data) {
                $('#live_data').html(data);
                initDataTable();
            },
            error: function() {
                $('#error').html('<div class="alert alert-danger" role="alert">Error loading applications</div>');
            }
        });
    }

    function initDataTable() {
        (function($) {
            'use strict';
            $(function() {
                if ($.fn.DataTable.isDataTable('#order-listing')) {
                    $('#order-listing').DataTable().destroy();
                }
                $('#order-listing').DataTable({
                    "aLengthMenu": [
                        [5, 10, 15, -1],
                        [5, 10, 15, "All"]
                    ],
                    "iDisplayLength": 10
                });
            });
        })(jQuery);
    }

    $(document).on('click', '.download-pdf-btn', function(e) {
        e.preventDefault();
        var applicationId = $(this).data('id');
        window.location.href = 'download-membership-application-pdf.php?id=' + applicationId;
    });

    $(document).on('click', '.change-status-btn', function() {
        var applicationId = $(this).data('id');
        var currentStatus = $(this).data('status');
        var btn = $(this);

        $.ajax({
            url: 'update-membership-application-status.php',
            type: 'POST',
            data: {
                application_id: applicationId,
                status: 'submitted'
            },
            success: function(response) {
                if (response.success) {
                    btn.removeClass('btn-outline-warning').addClass('btn-outline-success');
                    btn.text('<i class="fa fa-check"></i> Submitted').html('<i class="fa fa-check"></i> Submitted');
                    btn.prop('disabled', true);
                    loadApplications();
                    $('#error').html('<div class="alert alert-success" role="alert">Status updated successfully!</div>');
                } else {
                    $('#error').html('<div class="alert alert-danger" role="alert">Error updating status</div>');
                }
            },
            error: function() {
                $('#error').html('<div class="alert alert-danger" role="alert">Error updating status</div>');
            },
            dataType: 'json'
        });
    });
</script>

</body>

</html>
