<?php
session_start();
include_once('../../config/config.php');

$action = isset($_POST['action']) ? $_POST['action'] : '';

try {
    switch ($action) {
        case 'create':
            createTestimonial();
            break;
        case 'update':
            updateTestimonial();
            break;
        case 'delete':
            deleteTestimonial();
            break;
        default:
            echo 0;
    }
} catch (Exception $e) {
    echo 0;
}

function createTestimonial() {
    global $db;
    
    $customer_name = trim($_POST['customer_name'] ?? '');
    $customer_role = trim($_POST['customer_role'] ?? '');
    $testimonial_text = trim($_POST['testimonial_text'] ?? '');
    $rating = intval($_POST['rating'] ?? 5);
    $customer_image = '';
    
    // Validate
    if (empty($customer_name) || empty($customer_role) || empty($testimonial_text)) {
        echo 2;
        return;
    }
    
    // Handle image upload
    if (isset($_FILES['customer_image']) && $_FILES['customer_image']['size'] > 0) {
        $allowed = array('jpg', 'jpeg', 'png', 'gif');
        $filename = $_FILES['customer_image']['name'];
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        
        if (!in_array(strtolower($ext), $allowed)) {
            echo 3;
            return;
        }
        
        $upload_dir = '../../../assets/images/testimonials/';
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }
        
        $new_filename = 'testimonial_' . time() . '.' . $ext;
        $upload_path = $upload_dir . $new_filename;
        
        if (!move_uploaded_file($_FILES['customer_image']['tmp_name'], $upload_path)) {
            echo 2;
            return;
        }
        
        $customer_image = 'assets/images/testimonials/' . $new_filename;
    } else {
        echo 2;
        return;
    }
    
    try {
        $stmt = $db->prepare("INSERT INTO testimonials (customer_name, customer_role, customer_image, testimonial_text, rating, date_created) VALUES (:customer_name, :customer_role, :customer_image, :testimonial_text, :rating, NOW())");
        
        $result = $stmt->execute([
            ':customer_name' => $customer_name,
            ':customer_role' => $customer_role,
            ':customer_image' => $customer_image,
            ':testimonial_text' => $testimonial_text,
            ':rating' => $rating
        ]);
        
        echo ($result) ? 1 : 2;
    } catch (PDOException $e) {
        echo 2;
    }
}

function updateTestimonial() {
    global $db;
    
    $testimonial_id = intval($_POST['testimonial_id'] ?? 0);
    $customer_name = trim($_POST['customer_name'] ?? '');
    $customer_role = trim($_POST['customer_role'] ?? '');
    $testimonial_text = trim($_POST['testimonial_text'] ?? '');
    $rating = intval($_POST['rating'] ?? 5);
    $current_image = trim($_POST['current_image'] ?? '');
    $customer_image = $current_image;
    
    // Validate
    if ($testimonial_id <= 0 || empty($customer_name) || empty($customer_role) || empty($testimonial_text)) {
        echo 2;
        return;
    }
    
    // Handle image upload if new image provided
    if (isset($_FILES['customer_image']) && $_FILES['customer_image']['size'] > 0) {
        $allowed = array('jpg', 'jpeg', 'png', 'gif');
        $filename = $_FILES['customer_image']['name'];
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        
        if (!in_array(strtolower($ext), $allowed)) {
            echo 3;
            return;
        }
        
        $upload_dir = '../../../assets/images/testimonials/';
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }
        
        // Delete old image if it exists
        if (!empty($current_image)) {
            $old_path = '../../../' . $current_image;
            if (file_exists($old_path)) {
                unlink($old_path);
            }
        }
        
        $new_filename = 'testimonial_' . time() . '.' . $ext;
        $upload_path = $upload_dir . $new_filename;
        
        if (!move_uploaded_file($_FILES['customer_image']['tmp_name'], $upload_path)) {
            echo 2;
            return;
        }
        
        $customer_image = 'assets/images/testimonials/' . $new_filename;
    }
    
    try {
        $stmt = $db->prepare("UPDATE testimonials SET customer_name = :customer_name, customer_role = :customer_role, customer_image = :customer_image, testimonial_text = :testimonial_text, rating = :rating WHERE testimonial_id = :id");
        
        $result = $stmt->execute([
            ':id' => $testimonial_id,
            ':customer_name' => $customer_name,
            ':customer_role' => $customer_role,
            ':customer_image' => $customer_image,
            ':testimonial_text' => $testimonial_text,
            ':rating' => $rating
        ]);
        
        echo ($result) ? 1 : 2;
    } catch (PDOException $e) {
        echo 2;
    }
}

function deleteTestimonial() {
    global $db;
    
    $testimonial_id = intval($_POST['testimonial_id'] ?? 0);
    
    if ($testimonial_id <= 0) {
        echo 0;
        return;
    }
    
    try {
        // Get the image path before deleting
        $stmt = $db->prepare("SELECT customer_image FROM testimonials WHERE testimonial_id = :id");
        $stmt->execute([':id' => $testimonial_id]);
        $testimonial = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($testimonial) {
            // Delete image file if it exists
            if (!empty($testimonial['customer_image'])) {
                $image_path = '../../../' . $testimonial['customer_image'];
                if (file_exists($image_path)) {
                    unlink($image_path);
                }
            }
            
            // Delete from database
            $delete_stmt = $db->prepare("DELETE FROM testimonials WHERE testimonial_id = :id");
            $result = $delete_stmt->execute([':id' => $testimonial_id]);
            
            echo ($result) ? 1 : 0;
        } else {
            echo 0;
        }
    } catch (PDOException $e) {
        echo 0;
    }
}
?>
