<?php include_once('header.php'); ?>

<div class="container">
    <div class="card-deck mb-3 text-center">
        <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mt-3 mb-3 border-bottom" style="width: 100%;">
            <h1 class="h2">Loan Types Management</h1>
            <div class="btn-toolbar mb-2 mb-md-0">
                <div class="btn-group mr-2">
                    <button class="btn btn-sm btn-outline-primary" id="new_loan_type">Add New Loan Type</button>
                    <a class="btn btn-sm btn-outline-secondary" href="dashboard.php">Dashboard</a>
                </div>
            </div>
        </div>

        <div id="error" style="width: 100%; text-align: left;">
            <?php
            if (isset($_SESSION['success'])) {
                echo '<div class="alert alert-success alert-dismissible fade show" role="alert">';
                echo htmlspecialchars($_SESSION['success']);
                echo '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
                echo '</div>';
                unset($_SESSION['success']);
            }
            
            if (isset($_SESSION['error'])) {
                echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
                echo htmlspecialchars($_SESSION['error']);
                echo '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
                echo '</div>';
                unset($_SESSION['error']);
            }
            ?>
        </div>

        <!-- new loan type section -->
        <div id="new-loan-type" style="width: 100%; display: none;">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap pb-2 mb-3 border-bottom" style="width: 100%; text-align: left;">
                <div class="col-md-12 order-md-1">
                    <h4 class="mb-3">Create New Loan Type
                        <button style="float: right;" type="button" id="hide_loan_type" class="btn btn-md btn-secondary">Close</button>
                    </h4>

                    <form class="needs-validation" id="create-loan-type" method="post" action="manage-loan-types.php" enctype="multipart/form-data" novalidate>
                        <input type="hidden" name="action" value="create">
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="loanName">Loan Type Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="loan_name" placeholder="e.g., Normal Loan" required>
                                <div class="invalid-feedback">
                                    Loan name is required.
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="loanDescription">Loan Description <span class="text-danger">*</span></label>
                                <textarea class="form-control no-textboxio" name="loan_description" placeholder="Enter a detailed description of this loan product" rows="4" required></textarea>
                                <div class="invalid-feedback">
                                    Loan description is required.
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="interestRate">Monthly Interest Rate (%) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" name="interest_rate_monthly" placeholder="e.g., 3.5" step="0.01" min="0" required>
                                <div class="invalid-feedback">
                                    Monthly interest rate is required.
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="processingFee">Processing Fee (%) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" name="processing_fee" placeholder="e.g., 2.5" step="0.01" min="0" required>
                                <div class="invalid-feedback">
                                    Processing fee is required.
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="insuranceFee">Insurance Fee (% Yearly) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" name="insurance_fee_yearly" placeholder="e.g., 1.0" step="0.01" min="0" required>
                                <div class="invalid-feedback">
                                    Insurance fee is required.
                                </div>
                            </div>
                        </div>

                        <button class="btn btn-secondary btn-md" type="reset" style="float: right;">
                            Clear Form
                        </button>
                        <button class="btn btn-primary btn-md" type="submit" style="float: right; margin-right: 5px;">
                            Create Loan Type
                        </button>
                    </form>
                </div>
            </div>
        </div>
        <!-- end new loan type form -->

        <!-- Loan Types Table -->
        <div style="width: 100%">
            <div class="table-responsive">
                <div id="live_data" style="width: 100%; text-align: left;"></div>
            </div>
        </div>

    </div>

</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalLabel">Edit Loan Type</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" action="manage-loan-types.php" enctype="multipart/form-data">
                <input type="hidden" name="action" value="update">
                <input type="hidden" name="id" id="editId">
                
                <div class="modal-body">
                    <div class="form-group">
                        <label for="editLoanName">Loan Type Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="editLoanName" name="loan_name" required>
                    </div>

                    <div class="form-group">
                        <label for="editLoanDescription">Loan Description <span class="text-danger">*</span></label>
                        <textarea class="form-control no-textboxio" id="editLoanDescription" name="loan_description" rows="4" required></textarea>
                    </div>

                    <div class="form-group">
                        <label for="editInterestRate">Monthly Interest Rate (%) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="editInterestRate" name="interest_rate_monthly" step="0.01" min="0" required>
                    </div>

                    <div class="form-group">
                        <label for="editProcessingFee">Processing Fee (%) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="editProcessingFee" name="processing_fee" step="0.01" min="0" required>
                    </div>

                    <div class="form-group">
                        <label for="editInsuranceFee">Insurance Fee (% Yearly) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="editInsuranceFee" name="insurance_fee_yearly" step="0.01" min="0" required>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Bootstrap core JavaScript -->
<script type="text/javascript" src="../../js/jquery-3.2.1.min.js"></script>
<script src="../../js/vendor/popper.min.js"></script>
<script src="../../js/bootstrap.min.js"></script>
<script src="../../js/vendor/holder.min.js"></script>
<script type="text/javascript" src="../../js/validation.min.js"></script>
<script src="../../js/tables/jquery.dataTables.js"></script>
<script src="../../js/tables/dataTables.bootstrap4.js"></script>

<script>
    $(function() {
        loadLoanTypes();

        // Show new loan type form
        $(document).on('click', '#new_loan_type', function() {
            $('#new-loan-type').slideDown();
            $(this).hide();
        });

        // Hide new loan type form
        $(document).on('click', '#hide_loan_type', function() {
            $('#new-loan-type').slideUp();
            $('#new_loan_type').show();
            $('#create-loan-type')[0].reset();
        });

        // Edit button - Load data into modal (populate before modal opens)
        $('#editModal').on('show.bs.modal', function(e) {
            var button = $(e.relatedTarget);
            var id = button.data('id');
            var loanName = button.data('loan-name');
            var loanDescription = button.data('loan-description');
            var interestRate = button.data('interest-rate');
            var processingFee = button.data('processing-fee');
            var insuranceFee = button.data('insurance-fee');

            $('#editId').val(id);
            $('#editLoanName').val(loanName);
            $('#editLoanDescription').val(loanDescription);
            $('#editInterestRate').val(interestRate);
            $('#editProcessingFee').val(processingFee);
            $('#editInsuranceFee').val(insuranceFee);
        });

        // Delete button
        $(document).on('click', '.delete-btn', function() {
            var id = $(this).data('id');
            if (confirm('Are you sure you want to delete this loan type?')) {
                var form = $('<form method="post" action="manage-loan-types.php" style="display:none;">' +
                    '<input type="hidden" name="action" value="delete">' +
                    '<input type="hidden" name="id" value="' + id + '">' +
                    '</form>');
                $('body').append(form);
                form.submit();
            }
        });
    });

    function loadLoanTypes() {
        $.ajax({
            url: 'select-loan-types.php',
            type: 'GET',
            success: function(data) {
                $('#live_data').html(data);
                initDataTable();
            },
            error: function() {
                $('#error').html('<div class="alert alert-danger" role="alert">Error loading loan types</div>');
            }
        });
    }

    function initDataTable() {
        (function($) {
            'use strict';
            $(function() {
                if ($.fn.DataTable.isDataTable('#order-listing')) {
                    $('#order-listing').DataTable().destroy();
                }
                $('#order-listing').DataTable({
                    "aLengthMenu": [
                        [5, 10, 15, -1],
                        [5, 10, 15, "All"]
                    ],
                    "iDisplayLength": 10
                });
            });
        })(jQuery);
    }
</script>

</body>

</html>
