<?php
header('Content-Type: application/json');

include_once('../../config/config.php');

// Get the report type from query parameter
$reportType = isset($_GET['type']) ? $_GET['type'] : 'report';

// Validate report type
if (!in_array($reportType, ['report', 'document'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid report type']);
    exit;
}

try {
    // Fetch reports by type from database
    $stmt = $db->prepare("SELECT report_id, title, file, report_type, date FROM report WHERE report_type = :type ORDER BY date DESC");
    $stmt->execute([':type' => $reportType]);
    $reports = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Return JSON response
    echo json_encode($reports);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error']);
    exit;
}
?>
