<?php
session_start();
include_once('../../config/config.php');

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid application ID']);
    exit;
}

$application_id = intval($_GET['id']);

$statement = "SELECT 
    ila.*,
    lt.loan_name
FROM individual_loan_applications ila
LEFT JOIN loan_types lt ON ila.loan_type_id = lt.id
WHERE ila.id = :id";

try {
    $stmt = $db->prepare($statement);
    $stmt->execute([':id' => $application_id]);
    $data = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($data) {
        echo json_encode(['success' => true, 'data' => $data]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Application not found']);
    }

} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
