<?php
header('Content-Type: application/json');
require_once('../../config/connect.php');

// Use $connect variable from connect.php
$db = $connect;

if (!$db) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Database connection failed'
    ]);
    exit;
}

try {
    $search = isset($_GET['search']) ? trim($_GET['search']) : '';
    $category = isset($_GET['category']) ? trim($_GET['category']) : '';
    $limit = isset($_GET['limit']) ? intval($_GET['limit']) : 10;
    $offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;

    $query = "SELECT blog_id, blog_category, blog_title, blog_content, posted_by, post_thumb, post_image, status, date_posted, post_link FROM blog_posts WHERE status = 1";

    if (!empty($search)) {
        $search = $db->real_escape_string($search);
        $query .= " AND (blog_title LIKE '%{$search}%' OR blog_content LIKE '%{$search}%' OR blog_category LIKE '%{$search}%')";
    }

    if (!empty($category)) {
        $category = $db->real_escape_string($category);
        $query .= " AND blog_category = '{$category}'";
    }

    $query .= " ORDER BY date_posted DESC LIMIT {$limit} OFFSET {$offset}";

    $result = $db->query($query);
    
    if (!$result) {
        throw new Exception($db->error);
    }

    $posts = [];
    while ($row = $result->fetch_assoc()) {
        $posts[] = [
            'blog_id' => $row['blog_id'],
            'blog_category' => $row['blog_category'],
            'blog_title' => $row['blog_title'],
            'blog_content' => substr($row['blog_content'], 0, 150) . '...',
            'posted_by' => $row['posted_by'],
            'post_thumb' => $row['post_thumb'],
            'post_image' => $row['post_image'],
            'date_posted' => $row['date_posted'],
            'post_link' => $row['post_link']
        ];
    }

    // Get total count for pagination
    $countQuery = "SELECT COUNT(*) as total FROM blog_posts WHERE status = 1";
    if (!empty($search)) {
        $countQuery .= " AND (blog_title LIKE '%{$search}%' OR blog_content LIKE '%{$search}%' OR blog_category LIKE '%{$search}%')";
    }
    if (!empty($category)) {
        $countQuery .= " AND blog_category = '{$category}'";
    }

    $countResult = $db->query($countQuery);
    if (!$countResult) {
        throw new Exception($db->error);
    }

    $countRow = $countResult->fetch_assoc();
    $total = $countRow['total'];

    echo json_encode([
        'success' => true,
        'posts' => $posts,
        'total' => $total,
        'count' => count($posts)
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
