<?php include_once('header.php'); ?>



<div class="container">
  <div class="card-deck mb-3 text-center">
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom" style="width: 100%;">
      <h1 class="h2">System Users</h1>
      <div class="btn-toolbar mb-2 mb-md-0">
        <div class="btn-group mr-2">
          <button class="btn btn-sm btn-outline-secondary" id="new_user">Add New User</button>
          <a class="btn btn-sm btn-outline-primary" href="../../logout.php"><i class="fa fa-sign-out"></i> Logout</a>
        </div>
      </div>
    </div>

    <div id="error"></div>
    <!-- new user section -->
    <div id="new-user" style="width: 100%">
      <div class="d-flex justify-content-between flex-wrap flex-md-nowrap  pb-2 mb-3 border-bottom" style="width: 100%; text-align: left;">
        <div class="col-md-12 order-md-1">
          <h4 class="mb-3">Create New User
            <button style="float: right;" id="hide" class="btn btn-md btn-primary">Close</button>
          </h4>

          <form class="needs-validation" id="create-user" method="post">
            <div class="row">
              <div class="col-md-4 mb-3">
                <label for="firstName">First name</label>
                <input type="text" class="form-control" id="firstName" name="firstName" required>
              </div>
              <div class="col-md-4 mb-3">
                <label for="firstName">Last name</label>
                <input type="text" class="form-control" id="lastName" name="lastName" required>
              </div>
              <div class="col-md-4 mb-3">
                <label for="lastName">Email Address</label>
                <input type="email" class="form-control" id="email" name="email" required>

              </div>
            </div>
            <div class="row">
              <div class="col-md-4 mb-3">
                <label for="Username">Username</label>
                <input type="text" class="form-control" id="username" name="username" required>
              </div>
              <div class="col-md-4 mb-3">
                <label for="Password">Password</label>
                <input type="password" class="form-control" id="password" name="password" required>

              </div>
              <div class="col-md-4 mb-3">
                <label for="Password">Re-Enter Password</label>
                <input type="password" class="form-control" id="repass" name="repass" required>

              </div>
            </div>
            <button class="btn btn-primary btn-md" type="reset" name="reset" id="reset" style="float: right;">
              Clear Form
            </button>
            <button class="btn btn-primary btn-md" type="submit" name="create_account" id="create_account" style="float: right; margin-right: 5px;">
              Create User
            </button>
          </form>
        </div>
      </div>
    </div>
    <!-- end new user form -->

    <div class="table-responsive">
      <div id="live_data" style="width: 100%; text-align: left;"></div>
    </div>
  </div>

</div>


<!-- Bootstrap core JavaScript
    ================================================== -->
<!-- Placed at the end of the document so the pages load faster -->
<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
<script>
  window.jQuery || document.write('<script src="../../js/vendor/jquery-slim.min.js"><\/script>')
</script>
<script src="../../js/vendor/popper.min.js"></script>
<script src="../../js/bootstrap.min.js"></script>
<script src="../../js/vendor/holder.min.js"></script>
<script type="text/javascript" src="../../js/jquery-3.2.1.min.js"></script>
<script type="text/javascript" src="../../js/validation.min.js"></script>
<script src="../../js/tables/jquery.dataTables.js"></script>
<script src="../../js/tables/dataTables.bootstrap4.js"></script>

<script>
  (function($) {
    'use strict';
    $(function() {
      $('#order-listing').DataTable({
        "aLengthMenu": [
          [10, 20, 35, -1],
          [10, 20, 35, "All"]
        ],
        "iDisplayLength": 10
      });
    });
  })(jQuery);


  function fetchData() {
    $.ajax({
      url: "select-users.php",
      method: "POST",
      success: function(data) {
        $('#live_data').html(data);
      }
    });
  }
  $(document).ready(function() {

    //loads system users 
    $.ajax({
      url: "select-users.php",
      method: "POST",
      success: function(data) {
        $('#live_data').html(data);
      }
    });

    $('#new-user').hide(); //hide new user form on page load
    //when a new user button has been clicked
    $('#new_user').click(function() {
      $("#new-user").show();
      $("#hide").click(function() {
        $("#new-user").hide();
      })
    });


    //user login script
    /* validation */
    $("#create-user").validate({
      rules: {
        password: {
          required: true,
          minlength: 6
        },
        username: {
          required: true
        },
        repass: {
          required: true,
          equalTo: "#password"
        },
      },
      messages: {
        password: {
          required: "Please enter password"
        },
        username: "Please enter your username",
        repass: {
          required: "Please re enter the new password",
          equalTo: "Please confirm the password entered"
        }
      },
      submitHandler: submitForm
    });
    /* validation */

    /* login submit */
    function submitForm() {
      var data = $("#create-user").serialize();

      $.ajax({

        type: 'POST',
        url: 'sql_statements.php',
        data: data,
        beforeSend: function() {
          $("#error").fadeOut();
          $("#create_account").html('<i class="fa fa-spin fa-spinner"></i> Creating Account ...');
        },
        success: function(response) { //alert(response);

          //if the response returns true
          if (response == 1) {
            $("#error").fadeIn(2000, function() {
              $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span> User account has been created! Clear the form to add a new user.</div>');
            });

            $("#error").fadeOut(5000, function() {
              $("#new-user").hide();
            });
            //$("#new-user").fadeOut(9000,function(){});
            $("#create_account").html('Create New User ...');
            fetchData();
            $("#create-user")[0].reset();

          } else if (response == 2) {
            $("#error").fadeIn(2000, function() {
              $("#error").html('<div class="alert alert-error"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-lock"></span> There was an error creating a user account, Please try again!</div>');
              $("#login").html('<span class="fa fa-lock"></span> &nbsp; Account Locked');
            }); //Your username/password entered doesn't match
            $("#error").fadeOut(6000, function() {});
          } else if (response == 3) {
            $("#error").fadeIn(2000, function() {
              $("#error").html('<div class="alert alert-error" style="background-color:#fcf8e3 !important; color:#8a6d3b;"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-lock"></span> Password entered does not match with the Re Password!</div>');
              $("#create_account").html('Create New User');
            }); //Your username/password entered doesn't match
            $("#error").fadeOut(6000, function() {});
          }

        }
      });
      return false;
    }
    /* login submit */
  });

  //delete user details
  $(document).on('click', '.btn_delete', function() {
    var id = $(this).data("id3");
    var delete_user = "delete_user";
    //alert(user+" "+id); 
    if (confirm("Are you sure you want to remove this user?")) {
      $.ajax({
        url: "sql_statements.php",
        method: "POST",
        data: {
          userid: id,
          delete_user: delete_user
        },
        dataType: "text",
        success: function(data) {
          //alert(data); 
          if (data == 1) {
            $("#error").fadeIn(2000, function() {
              $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span>&nbsp; User account has been removed!</div>');
            }); //Your username/password entered doesn't match
            $("#error").fadeOut(5000, function() {});
          }
          fetchData();
        }
      });
    }
  });
  Holder.addTheme('thumb', {
    bg: '#55595c',
    fg: '#eceeef',
    text: 'Thumbnail'
  });
</script>
</body>

</html>