<?php
/**
 * Get Loan Types
 * Fetches all loan types from the database
 */

// Set JSON header
header('Content-Type: application/json');

// Include database class
require_once('class.php');

try {
    // Initialize database connection
    $con = new DB;
    
    // Query to get all loan types
    $conditions = array(
        'order_by' => 'id ASC'
    );
    
    $loanTypes = $con->getRows('loan_types', $conditions);
    
    // Return successful response
    echo json_encode([
        'success' => true,
        'data' => $loanTypes ? $loanTypes : [],
        'count' => $loanTypes ? count($loanTypes) : 0
    ]);
    
} catch (Exception $e) {
    // Return error response
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching loan types: ' . $e->getMessage()
    ]);
}
?>
